/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.LogContainerCmd;
import java.util.function.Consumer;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;

public final class LogUtils {
    public static void followOutput(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer, OutputFrame.OutputType ... types) {
        LogContainerCmd cmd = dockerClient.logContainerCmd(containerId).withFollowStream(true).withSince(0);
        FrameConsumerResultCallback callback = new FrameConsumerResultCallback();
        for (OutputFrame.OutputType type : types) {
            callback.addConsumer(type, consumer);
            if (type == OutputFrame.OutputType.STDOUT) {
                cmd.withStdOut(true);
            }
            if (type != OutputFrame.OutputType.STDERR) continue;
            cmd.withStdErr(true);
        }
        cmd.exec(callback);
    }

    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

