/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.glassfish.jersey.message.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testcontainers.shaded.javax.ws.rs.core.AbstractMultivaluedMap;
import org.testcontainers.shaded.javax.ws.rs.core.MultivaluedMap;
import org.testcontainers.shaded.javax.ws.rs.ext.RuntimeDelegate;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Function;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.Lists;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.Maps;
import org.testcontainers.shaded.org.glassfish.jersey.internal.LocalizationMessages;
import org.testcontainers.shaded.org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.testcontainers.shaded.org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;

public final class HeaderUtils {
    private static final Logger LOGGER = Logger.getLogger(HeaderUtils.class.getName());

    public static AbstractMultivaluedMap<String, String> createInbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<String>();
    }

    public static <V> MultivaluedMap<String, V> empty() {
        return ImmutableMultivaluedMap.empty();
    }

    public static AbstractMultivaluedMap<String, Object> createOutbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<Object>();
    }

    public static String asString(Object headerValue, RuntimeDelegate rd) {
        RuntimeDelegate.HeaderDelegate<?> hp;
        if (headerValue == null) {
            return null;
        }
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (rd == null) {
            rd = RuntimeDelegate.getInstance();
        }
        return (hp = rd.createHeaderDelegate(headerValue.getClass())) != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public static List<String> asStringList(List<Object> headerValues, RuntimeDelegate rd) {
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        final RuntimeDelegate delegate = rd == null ? RuntimeDelegate.getInstance() : rd;
        return Lists.transform(headerValues, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input == null ? "[null]" : HeaderUtils.asString(input, delegate);
            }
        });
    }

    public static MultivaluedMap<String, String> asStringHeaders(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        final RuntimeDelegate rd = RuntimeDelegate.getInstance();
        return new AbstractMultivaluedMap<String, String>(Maps.transformValues(headers, (Function)new Function<List<Object>, List<String>>(){

            public List<String> apply(List<Object> input) {
                return HeaderUtils.asStringList(input, rd);
            }
        })){};
    }

    public static Map<String, String> asStringHeadersSingleValue(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        RuntimeDelegate rd = RuntimeDelegate.getInstance();
        ImmutableMap.Builder immutableMapBuilder = new ImmutableMap.Builder();
        for (Map.Entry entry : headers.entrySet()) {
            immutableMapBuilder.put(entry.getKey(), (Object)HeaderUtils.asHeaderString((List)entry.getValue(), rd));
        }
        return immutableMapBuilder.build();
    }

    public static String asHeaderString(List<Object> values, RuntimeDelegate rd) {
        if (values == null) {
            return null;
        }
        Iterator<String> stringValues = HeaderUtils.asStringList(values, rd).iterator();
        if (!stringValues.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(stringValues.next());
        while (stringValues.hasNext()) {
            buffer.append(',').append(stringValues.next());
        }
        return buffer.toString();
    }

    public static void checkHeaderChanges(Map<String, String> headersSnapshot, MultivaluedMap<String, Object> currentHeaders, String connectorName) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            RuntimeDelegate rd = RuntimeDelegate.getInstance();
            HashSet changedHeaderNames = new HashSet();
            for (Map.Entry entry : currentHeaders.entrySet()) {
                String newValue;
                if (!headersSnapshot.containsKey(entry.getKey())) {
                    changedHeaderNames.add(entry.getKey());
                    continue;
                }
                String prevValue = headersSnapshot.get(entry.getKey());
                if (prevValue.equals(newValue = HeaderUtils.asHeaderString((List)currentHeaders.get(entry.getKey()), rd))) continue;
                changedHeaderNames.add(entry.getKey());
            }
            if (!changedHeaderNames.isEmpty() && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(LocalizationMessages.SOME_HEADERS_NOT_SENT(connectorName, ((Object)changedHeaderNames).toString()));
            }
        }
    }

    private HeaderUtils() {
        throw new AssertionError((Object)"No instances allowed.");
    }
}

