/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class RestartPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="MaximumRetryCount")
    private Integer maximumRetryCount = 0;
    @JsonProperty(value="Name")
    private String name = "";

    public RestartPolicy() {
    }

    private RestartPolicy(int maximumRetryCount, String name) {
        Preconditions.checkNotNull(name, "name is null");
        this.maximumRetryCount = maximumRetryCount;
        this.name = name;
    }

    public static RestartPolicy noRestart() {
        return new RestartPolicy();
    }

    public static RestartPolicy alwaysRestart() {
        return new RestartPolicy(0, "always");
    }

    public static RestartPolicy onFailureRestart(int maximumRetryCount) {
        return new RestartPolicy(maximumRetryCount, "on-failure");
    }

    public static RestartPolicy unlessStoppedRestart() {
        return new RestartPolicy(0, "unless-stopped");
    }

    public Integer getMaximumRetryCount() {
        return this.maximumRetryCount;
    }

    public String getName() {
        return this.name;
    }

    public static RestartPolicy parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split(":");
            String name = parts[0];
            if ("no".equals(name)) {
                return RestartPolicy.noRestart();
            }
            if ("always".equals(name)) {
                return RestartPolicy.alwaysRestart();
            }
            if ("unless-stopped".equals(name)) {
                return RestartPolicy.unlessStoppedRestart();
            }
            if ("on-failure".equals(name)) {
                int count = 0;
                if (parts.length == 2) {
                    count = Integer.parseInt(parts[1]);
                }
                return RestartPolicy.onFailureRestart(count);
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing RestartPolicy '" + serialized + "'");
        }
    }

    public String toString() {
        String result = this.name.isEmpty() ? "no" : this.name;
        return this.maximumRetryCount > 0 ? result + ":" + this.maximumRetryCount : result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RestartPolicy) {
            RestartPolicy other = (RestartPolicy)obj;
            return new EqualsBuilder().append((Object)this.maximumRetryCount, (Object)other.getMaximumRetryCount()).append((Object)this.name, (Object)other.getName()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.maximumRetryCount).append((Object)this.name).toHashCode();
    }
}

