/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonParser;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.core.ObjectCodec;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.NullNode;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Ports
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<ExposedPort, Binding[]> ports = new HashMap<ExposedPort, Binding[]>();

    public Ports() {
    }

    public Ports(ExposedPort exposedPort, Binding host) {
        this.bind(exposedPort, host);
    }

    public Ports(PortBinding ... portBindings) {
        this.add(portBindings);
    }

    public void bind(ExposedPort exposedPort, Binding binding) {
        if (this.ports.containsKey(exposedPort)) {
            Object[] bindings = this.ports.get(exposedPort);
            this.ports.put(exposedPort, (Binding[])ArrayUtils.add((Object[])bindings, (Object)binding));
        } else if (binding == null) {
            this.ports.put(exposedPort, null);
        } else {
            this.ports.put(exposedPort, new Binding[]{binding});
        }
    }

    public void add(PortBinding ... portBindings) {
        for (PortBinding binding : portBindings) {
            this.bind(binding.getExposedPort(), binding.getBinding());
        }
    }

    public String toString() {
        return this.ports.toString();
    }

    public Map<ExposedPort, Binding[]> getBindings() {
        return this.ports;
    }

    public static class Serializer
    extends JsonSerializer<Ports> {
        @Override
        public void serialize(Ports portBindings, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            for (Map.Entry<ExposedPort, Binding[]> entry : portBindings.getBindings().entrySet()) {
                jsonGen.writeFieldName(entry.getKey().toString());
                if (entry.getValue() != null) {
                    jsonGen.writeStartArray();
                    for (Binding binding : entry.getValue()) {
                        jsonGen.writeStartObject();
                        jsonGen.writeStringField("HostIp", binding.getHostIp() == null ? "" : binding.getHostIp());
                        jsonGen.writeStringField("HostPort", binding.getHostPortSpec() == null ? "" : binding.getHostPortSpec());
                        jsonGen.writeEndObject();
                    }
                    jsonGen.writeEndArray();
                    continue;
                }
                jsonGen.writeNull();
            }
            jsonGen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Ports> {
        @Override
        public Ports deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Ports out = new Ports();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator<Map.Entry<String, JsonNode>> it = node.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> portNode = it.next();
                JsonNode bindingsArray = portNode.getValue();
                if (bindingsArray.equals(NullNode.getInstance())) {
                    out.bind(ExposedPort.parse(portNode.getKey()), null);
                    continue;
                }
                for (int i = 0; i < bindingsArray.size(); ++i) {
                    JsonNode bindingNode = bindingsArray.get(i);
                    if (bindingNode.equals(NullNode.getInstance())) continue;
                    String hostIp = bindingNode.get("HostIp").textValue();
                    String hostPort = bindingNode.get("HostPort").textValue();
                    out.bind(ExposedPort.parse(portNode.getKey()), new Binding(hostIp, hostPort));
                }
            }
            return out;
        }
    }

    public static class Binding {
        private final String hostIp;
        private final String hostPortSpec;

        public static Binding bindPortSpec(String portSpec) {
            return new Binding(null, portSpec);
        }

        public static Binding bindIp(String hostIp) {
            return new Binding(hostIp, null);
        }

        public static Binding bindIpAndPort(String hostIp, int port) {
            return new Binding(hostIp, "" + port);
        }

        public static Binding bindIpAndPortRange(String hostIp, int lowPort, int highPort) {
            return new Binding(hostIp, lowPort + "-" + highPort);
        }

        public static Binding bindPortRange(int lowPort, int highPort) {
            return Binding.bindIpAndPortRange(null, lowPort, highPort);
        }

        public static Binding bindPort(int port) {
            return Binding.bindIpAndPort(null, port);
        }

        public static Binding empty() {
            return new Binding(null, null);
        }

        public Binding(String hostIp, String hostPortSpec) {
            this.hostIp = StringUtils.isEmpty((String)hostIp) ? null : hostIp;
            this.hostPortSpec = hostPortSpec;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public String getHostPortSpec() {
            return this.hostPortSpec;
        }

        public static Binding parse(String serialized) throws IllegalArgumentException {
            try {
                if (serialized.isEmpty()) {
                    return Binding.empty();
                }
                String[] parts = serialized.split(":");
                switch (parts.length) {
                    case 2: {
                        return new Binding(parts[0], parts[1]);
                    }
                    case 1: {
                        return parts[0].contains(".") ? Binding.bindIp(parts[0]) : Binding.bindPortSpec(parts[0]);
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error parsing Binding '" + serialized + "'");
            }
        }

        public String toString() {
            if (StringUtils.isEmpty((String)this.hostIp)) {
                return this.hostPortSpec;
            }
            if (this.hostPortSpec == null) {
                return this.hostIp;
            }
            return this.hostIp + ":" + this.hostPortSpec;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Binding) {
                Binding other = (Binding)obj;
                return new EqualsBuilder().append((Object)this.hostIp, (Object)other.getHostIp()).append((Object)this.hostPortSpec, (Object)other.getHostPortSpec()).isEquals();
            }
            return super.equals(obj);
        }
    }
}

