/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.startupcheck;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;

public abstract class StartupCheckStrategy {
    private static final RateLimiter DOCKER_CLIENT_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();

    public boolean waitUntilStartupSuccessful(DockerClient dockerClient, String containerId) {
        Boolean[] startedOK = new Boolean[]{null};
        Unreliables.retryUntilTrue(30, TimeUnit.SECONDS, () -> DOCKER_CLIENT_RATE_LIMITER.getWhenReady(() -> {
            StartupStatus state = this.checkStartupState(dockerClient, containerId);
            switch (state) {
                case SUCCESSFUL: {
                    startedOK[0] = true;
                    return true;
                }
                case FAILED: {
                    startedOK[0] = false;
                    return true;
                }
            }
            return false;
        }));
        return startedOK[0];
    }

    public abstract StartupStatus checkStartupState(DockerClient var1, String var2);

    protected InspectContainerResponse.ContainerState getCurrentState(DockerClient dockerClient, String containerId) {
        return dockerClient.inspectContainerCmd(containerId).exec().getState();
    }

    public static enum StartupStatus {
        NOT_YET_KNOWN,
        SUCCESSFUL,
        FAILED;

    }
}

