/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.jaxrs;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.github.dockerjava.api.async.ResultCallback;
import org.testcontainers.shaded.com.github.dockerjava.api.command.BuildImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.model.AuthConfigurations;
import org.testcontainers.shaded.com.github.dockerjava.api.model.BuildResponseItem;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.async.JsonStreamProcessor;
import org.testcontainers.shaded.com.github.dockerjava.jaxrs.AbstrAsyncDockerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.jaxrs.async.AbstractCallbackNotifier;
import org.testcontainers.shaded.com.github.dockerjava.jaxrs.async.POSTCallbackNotifier;
import org.testcontainers.shaded.javax.ws.rs.client.Entity;
import org.testcontainers.shaded.javax.ws.rs.client.Invocation;
import org.testcontainers.shaded.javax.ws.rs.client.WebTarget;
import org.testcontainers.shaded.org.glassfish.jersey.client.RequestEntityProcessing;

public class BuildImageCmdExec
extends AbstrAsyncDockerCmdExec<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImageCmdExec.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public BuildImageCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    private Invocation.Builder resourceWithOptionalAuthConfig(BuildImageCmd command, Invocation.Builder request) {
        AuthConfigurations authConfigs = BuildImageCmdExec.firstNonNull(command.getBuildAuthConfigs(), this.getBuildAuthConfigs());
        if (authConfigs != null && !authConfigs.getConfigs().isEmpty()) {
            request = request.header("X-Registry-Config", this.registryConfigs(authConfigs));
        }
        return request;
    }

    private static AuthConfigurations firstNonNull(AuthConfigurations fromCommand, AuthConfigurations fromConfig) {
        if (fromCommand != null) {
            return fromCommand;
        }
        if (fromConfig != null) {
            return fromConfig;
        }
        return null;
    }

    @Override
    protected AbstractCallbackNotifier<BuildResponseItem> callbackNotifier(BuildImageCmd command, ResultCallback<BuildResponseItem> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/build");
        String dockerFilePath = command.getPathToDockerfile();
        if (dockerFilePath != null && command.getRemote() == null && !"Dockerfile".equals(dockerFilePath)) {
            webTarget = webTarget.queryParam("dockerfile", dockerFilePath);
        }
        if (command.getTag() != null) {
            webTarget = webTarget.queryParam("t", command.getTag());
        }
        if (command.getRemote() != null) {
            webTarget = webTarget.queryParam("remote", command.getRemote().toString());
        }
        webTarget = this.booleanQueryParam(webTarget, "q", command.isQuiet());
        webTarget = this.booleanQueryParam(webTarget, "nocache", command.hasNoCacheEnabled());
        webTarget = this.booleanQueryParam(webTarget, "pull", command.hasPullEnabled());
        webTarget = this.booleanQueryParam(webTarget, "rm", command.hasRemoveEnabled());
        webTarget = this.booleanQueryParam(webTarget, "forcerm", command.isForcerm());
        if (command.hasRemoveEnabled() == null || !command.hasRemoveEnabled().booleanValue()) {
            webTarget = webTarget.queryParam("rm", "false");
        }
        if (command.getMemory() != null) {
            webTarget = webTarget.queryParam("memory", command.getMemory());
        }
        if (command.getMemswap() != null) {
            webTarget = webTarget.queryParam("memswap", command.getMemswap());
        }
        if (command.getCpushares() != null) {
            webTarget = webTarget.queryParam("cpushares", command.getCpushares());
        }
        if (command.getCpusetcpus() != null) {
            webTarget = webTarget.queryParam("cpusetcpus", command.getCpusetcpus());
        }
        if (command.hasRemoveEnabled() == null || !command.hasRemoveEnabled().booleanValue()) {
            webTarget = webTarget.queryParam("rm", "false");
        }
        webTarget = this.writeMap(webTarget, "buildargs", command.getBuildArgs());
        if (command.getShmsize() != null) {
            webTarget = webTarget.queryParam("shmsize", command.getShmsize());
        }
        webTarget = this.writeMap(webTarget, "labels", command.getLabels());
        webTarget.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        webTarget.property("jersey.config.client.chunkedEncodingSize", 0x100000);
        LOGGER.trace("POST: {}", (Object)webTarget);
        return new POSTCallbackNotifier<BuildResponseItem>(new JsonStreamProcessor<BuildResponseItem>(BuildResponseItem.class), resultCallback, this.resourceWithOptionalAuthConfig(command, webTarget.request()).accept("text/plain"), Entity.entity(command.getTarInputStream(), "application/tar"));
    }

    private WebTarget writeMap(WebTarget webTarget, String name, Map<String, String> value) {
        if (value != null && !value.isEmpty()) {
            try {
                return webTarget.queryParam(name, URLEncoder.encode(MAPPER.writeValueAsString(value), "UTF-8"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return webTarget;
    }
}

