/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.api.model;

import java.io.Serializable;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Repository;
import org.testcontainers.shaded.com.google.common.base.Objects;
import org.testcontainers.shaded.com.google.common.base.Optional;

public class Identifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Repository repository;
    public final Optional<String> tag;

    public Identifier(Repository repository, String tag) {
        this.repository = repository;
        this.tag = tag == null ? Optional.absent() : Optional.of(tag);
    }

    public static Identifier fromCompoundString(String identifier) {
        String[] parts = identifier.split("/");
        if (parts.length != 2) {
            String[] rhs = identifier.split(":");
            if (rhs.length != 2) {
                return new Identifier(new Repository(identifier), null);
            }
            return new Identifier(new Repository(rhs[0]), rhs[1]);
        }
        String[] rhs = parts[1].split(":");
        if (rhs.length != 2) {
            return new Identifier(new Repository(identifier), null);
        }
        return new Identifier(new Repository(parts[0] + "/" + rhs[0]), rhs[1]);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("repository", this.repository).add("tag", this.tag).toString();
    }
}

