/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.handler.ssl;

import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.tomcat.jni.CertificateRequestedCallback;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSLContext;
import org.testcontainers.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.testcontainers.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import org.testcontainers.shaded.io.netty.handler.ssl.ClientAuth;
import org.testcontainers.shaded.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSsl;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSslContext;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSslEngine;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSslEngineMap;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSslExtendedKeyMaterialManager;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import org.testcontainers.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import org.testcontainers.shaded.io.netty.util.internal.logging.InternalLogger;
import org.testcontainers.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class OpenSslClientContext
extends OpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslClientContext.class);
    private final OpenSslSessionContext sessionContext;

    @Deprecated
    public OpenSslClientContext() throws SSLException {
        this((File)null, null, null, null, null, null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile) throws SSLException {
        this(certChainFile, null);
    }

    @Deprecated
    public OpenSslClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        this(null, trustManagerFactory);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, null, null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, null, null, ciphers, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, apn, sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, null, null, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public OpenSslClientContext(File trustCertCollectionFile, TrustManagerFactory trustManagerFactory, File keyCertChainFile, File keyFile, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(OpenSslClientContext.toX509CertificatesInternal(trustCertCollectionFile), trustManagerFactory, OpenSslClientContext.toX509CertificatesInternal(keyCertChainFile), OpenSslClientContext.toPrivateKeyInternal(keyFile, keyPassword), keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslClientContext(X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        super(ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, 0, (Certificate[])keyCertChain, ClientAuth.NONE);
        boolean success = false;
        try {
            if (key == null && keyCertChain != null || key != null && keyCertChain == null) {
                throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
            }
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                try {
                    if (!OpenSsl.supportsKeyManagerFactory()) {
                        if (keyManagerFactory != null) {
                            throw new IllegalArgumentException("KeyManagerFactory not supported");
                        }
                        if (keyCertChain != null && key != null) {
                            OpenSslClientContext.setKeyMaterial(this.ctx, keyCertChain, key, keyPassword);
                        }
                    } else {
                        if (keyCertChain != null) {
                            keyManagerFactory = OpenSslClientContext.buildKeyManagerFactory(keyCertChain, key, keyPassword, keyManagerFactory);
                        }
                        if (keyManagerFactory != null) {
                            X509KeyManager keyManager = OpenSslClientContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers());
                            OpenSslKeyMaterialManager materialManager = OpenSslClientContext.useExtendedKeyManager(keyManager) ? new OpenSslExtendedKeyMaterialManager((X509ExtendedKeyManager)keyManager, keyPassword) : new OpenSslKeyMaterialManager(keyManager, keyPassword);
                            SSLContext.setCertRequestedCallback((long)this.ctx, (CertificateRequestedCallback)new OpenSslCertificateRequestedCallback(this.engineMap, materialManager));
                        }
                    }
                }
                catch (Exception e) {
                    throw new SSLException("failed to set certificate and key", e);
                }
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                try {
                    if (trustCertCollection != null) {
                        trustManagerFactory = OpenSslClientContext.buildTrustManagerFactory(trustCertCollection, trustManagerFactory);
                    } else if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                    }
                    X509TrustManager manager = OpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    if (OpenSslClientContext.useExtendedTrustManager(manager)) {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(this.engineMap, (X509ExtendedTrustManager)manager));
                    } else {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new TrustManagerVerifyCallback(this.engineMap, manager));
                    }
                }
                catch (Exception e) {
                    throw new SSLException("unable to setup trustmanager", e);
                }
                this.sessionContext = new OpenSslClientSessionContext(this);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroy();
            }
        }
        {
            return;
        }
    }

    @Override
    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    OpenSslKeyMaterialManager keyMaterialManager() {
        return null;
    }

    private static final class OpenSslCertificateRequestedCallback
    implements CertificateRequestedCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslCertificateRequestedCallback(OpenSslEngineMap engineMap, OpenSslKeyMaterialManager keyManagerHolder) {
            this.engineMap = engineMap;
            this.keyManagerHolder = keyManagerHolder;
        }

        public void requested(long ssl, byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) {
            OpenSslEngine engine = this.engineMap.get(ssl);
            try {
                X500Principal[] issuers;
                Set<String> keyTypesSet = OpenSslCertificateRequestedCallback.supportedClientKeyTypes(keyTypeBytes);
                String[] keyTypes = keyTypesSet.toArray(new String[keyTypesSet.size()]);
                if (asn1DerEncodedPrincipals == null) {
                    issuers = null;
                } else {
                    issuers = new X500Principal[asn1DerEncodedPrincipals.length];
                    for (int i = 0; i < asn1DerEncodedPrincipals.length; ++i) {
                        issuers[i] = new X500Principal(asn1DerEncodedPrincipals[i]);
                    }
                }
                this.keyManagerHolder.setKeyMaterial(engine, keyTypes, issuers);
            }
            catch (Throwable cause) {
                logger.debug("request of key failed", cause);
                SSLHandshakeException e = new SSLHandshakeException("General OpenSslEngine problem");
                e.initCause(cause);
                engine.handshakeException = e;
            }
        }

        private static Set<String> supportedClientKeyTypes(byte[] clientCertificateTypes) {
            HashSet<String> result = new HashSet<String>(clientCertificateTypes.length);
            for (byte keyTypeCode : clientCertificateTypes) {
                String keyType = OpenSslCertificateRequestedCallback.clientKeyType(keyTypeCode);
                if (keyType == null) continue;
                result.add(keyType);
            }
            return result;
        }

        private static String clientKeyType(byte clientCertificateType) {
            switch (clientCertificateType) {
                case 1: {
                    return "RSA";
                }
                case 3: {
                    return "DH_RSA";
                }
                case 64: {
                    return "EC";
                }
                case 65: {
                    return "EC_RSA";
                }
                case 66: {
                    return "EC_EC";
                }
            }
            return null;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends OpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap engineMap, X509ExtendedTrustManager manager) {
            super(engineMap);
            this.manager = manager;
        }

        @Override
        void verify(OpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
            this.manager.checkServerTrusted(peerCerts, auth, engine);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends OpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap engineMap, X509TrustManager manager) {
            super(engineMap);
            this.manager = manager;
        }

        @Override
        void verify(OpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
            this.manager.checkServerTrusted(peerCerts, auth);
        }
    }

    private static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        private OpenSslClientSessionContext(OpenSslContext context) {
            super(context);
        }

        @Override
        public void setSessionTimeout(int seconds) {
            if (seconds < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionTimeout() {
            return 0;
        }

        @Override
        public void setSessionCacheSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionCacheSize() {
            return 0;
        }

        @Override
        public void setSessionCacheEnabled(boolean enabled) {
        }

        @Override
        public boolean isSessionCacheEnabled() {
            return false;
        }
    }
}

