/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.jaxrs.filter;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.BadRequestException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.ConflictException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.InternalServerErrorException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.NotAcceptableException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.NotFoundException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.NotModifiedException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.UnauthorizedException;
import org.testcontainers.shaded.javax.ws.rs.client.ClientRequestContext;
import org.testcontainers.shaded.javax.ws.rs.client.ClientResponseContext;
import org.testcontainers.shaded.javax.ws.rs.client.ClientResponseFilter;
import org.testcontainers.shaded.javax.ws.rs.core.MediaType;

public class ResponseStatusExceptionFilter
implements ClientResponseFilter {
    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        int status = responseContext.getStatus();
        switch (status) {
            case 200: 
            case 201: 
            case 204: {
                return;
            }
            case 304: {
                throw new NotModifiedException(this.getBodyAsMessage(responseContext));
            }
            case 400: {
                throw new BadRequestException(this.getBodyAsMessage(responseContext));
            }
            case 401: {
                throw new UnauthorizedException(this.getBodyAsMessage(responseContext));
            }
            case 404: {
                throw new NotFoundException(this.getBodyAsMessage(responseContext));
            }
            case 406: {
                throw new NotAcceptableException(this.getBodyAsMessage(responseContext));
            }
            case 409: {
                throw new ConflictException(this.getBodyAsMessage(responseContext));
            }
            case 500: {
                throw new InternalServerErrorException(this.getBodyAsMessage(responseContext));
            }
        }
        throw new DockerException(this.getBodyAsMessage(responseContext), status);
    }

    private String getBodyAsMessage(ClientResponseContext responseContext) throws IOException {
        int contentLength;
        if (responseContext.hasEntity() && (contentLength = responseContext.getLength()) != -1) {
            String charsetName;
            byte[] buffer = new byte[contentLength];
            try {
                InputStream entityStream = responseContext.getEntityStream();
                IOUtils.readFully(entityStream, buffer);
                entityStream.close();
            }
            catch (EOFException e) {
                return null;
            }
            Charset charset = null;
            MediaType mediaType = responseContext.getMediaType();
            if (mediaType != null && (charsetName = mediaType.getParameters().get("charset")) != null) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            return new String(buffer, charset);
        }
        return null;
    }
}

