/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.jersey.repackaged.com.google.common.collect;

import java.io.Serializable;
import org.testcontainers.shaded.javax.annotation.Nullable;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Function;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Objects;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Preconditions;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.Ordering;

final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(F left, F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.ordering));
        String string2 = String.valueOf(String.valueOf(this.function));
        return new StringBuilder(13 + string.length() + string2.length()).append(string).append(".onResultOf(").append(string2).append(")").toString();
    }
}

