/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.SystemUtils;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.IndefiniteWaitOneShotStartupCheckStrategy;
import org.testcontainers.shaded.com.google.common.base.Joiner;
import org.testcontainers.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.testcontainers.utility.PathUtils;

class ContainerisedDockerCompose
extends GenericContainer<ContainerisedDockerCompose>
implements DockerCompose {
    public ContainerisedDockerCompose(List<File> composeFiles, String identifier) {
        super("docker/compose:1.8.0");
        this.validateFileList(composeFiles);
        this.addEnv("COMPOSE_PROJECT_NAME", identifier);
        File dockerComposeBaseFile = composeFiles.get(0);
        String pwd = dockerComposeBaseFile.getAbsoluteFile().getParentFile().getAbsolutePath();
        String containerPwd = SystemUtils.IS_OS_WINDOWS ? PathUtils.createMinGWPath(pwd).substring(1) : pwd;
        List absoluteDockerComposeFiles = composeFiles.stream().map(file -> containerPwd + "/" + file.getAbsoluteFile().getName()).collect(Collectors.toList());
        String composeFileEnvVariableValue = Joiner.on(File.pathSeparator).join(absoluteDockerComposeFiles);
        this.logger().debug("Set env COMPOSE_FILE={}", (Object)composeFileEnvVariableValue);
        this.addEnv("COMPOSE_FILE", composeFileEnvVariableValue);
        this.addFileSystemBind(pwd, containerPwd, BindMode.READ_ONLY);
        this.addFileSystemBind("/var/run/docker.sock", "/docker.sock", BindMode.READ_WRITE);
        this.addEnv("DOCKER_HOST", "unix:///docker.sock");
        this.setStartupCheckStrategy(new IndefiniteWaitOneShotStartupCheckStrategy());
        this.setWorkingDirectory(containerPwd);
    }

    @Override
    public void start() {
        super.start();
        this.followOutput(new Slf4jLogConsumer(this.logger()));
        this.logger().info("Docker Compose container is running for command: {}", (Object)Joiner.on(" ").join(this.getCommandParts()));
        while (this.isRunning().booleanValue()) {
            this.logger().trace("Compose container is still running");
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        this.logger().info("Docker Compose has finished running");
    }
}

