/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.testcontainers.containers.output.OutputFrame;

public class Slf4jLogConsumer
implements Consumer<OutputFrame> {
    private final Logger logger;
    private String prefix = "";
    private static final Pattern ANSI_CODE_PATTERN = Pattern.compile("\\[\\d[ABCD]");

    public Slf4jLogConsumer(Logger logger) {
        this.logger = logger;
    }

    public Slf4jLogConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    @Override
    public void accept(OutputFrame outputFrame) {
        String utf8String;
        if (outputFrame != null && (utf8String = outputFrame.getUtf8String()) != null) {
            OutputFrame.OutputType outputType = outputFrame.getType();
            String message = utf8String.trim();
            if (ANSI_CODE_PATTERN.matcher(message).matches()) {
                return;
            }
            switch (outputType) {
                case END: {
                    break;
                }
                case STDOUT: 
                case STDERR: {
                    this.logger.info("{}{}: {}", new Object[]{this.prefix, outputType, message});
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected outputType " + (Object)((Object)outputType));
                }
            }
        }
    }
}

