/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.api.model;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.com.github.dockerjava.api.model.AccessMode;
import org.testcontainers.shaded.com.github.dockerjava.api.model.SELContext;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Volume;

public class Bind {
    private String path;
    private Volume volume;
    private AccessMode accessMode;
    private SELContext secMode;

    public Bind(String path, Volume volume) {
        this(path, volume, AccessMode.DEFAULT, SELContext.DEFAULT);
    }

    public Bind(String path, Volume volume, AccessMode accessMode) {
        this(path, volume, accessMode, SELContext.DEFAULT);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode) {
        this.path = path;
        this.volume = volume;
        this.accessMode = accessMode;
        this.secMode = secMode;
    }

    public String getPath() {
        return this.path;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public SELContext getSecMode() {
        return this.secMode;
    }

    public static Bind parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    return new Bind(parts[0], new Volume(parts[1]));
                }
                case 3: {
                    String[] flags = parts[2].split(",");
                    AccessMode accessMode = AccessMode.DEFAULT;
                    SELContext seMode = SELContext.DEFAULT;
                    for (String p : flags) {
                        if (p.length() == 2) {
                            accessMode = AccessMode.valueOf(p.toLowerCase());
                            continue;
                        }
                        seMode = SELContext.fromString(p);
                    }
                    return new Bind(parts[0], new Volume(parts[1]), accessMode, seMode);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bind) {
            Bind other = (Bind)obj;
            return new EqualsBuilder().append(this.path, other.getPath()).append(this.volume, other.getVolume()).append((Object)this.accessMode, (Object)other.getAccessMode()).append((Object)this.secMode, (Object)other.getSecMode()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.path).append(this.volume).append((Object)this.accessMode).append((Object)this.secMode).toHashCode();
    }

    public String toString() {
        return String.format("%s:%s:%s%s", this.path, this.volume.getPath(), this.accessMode.toString(), this.secMode != SELContext.none ? "," + this.secMode.toString() : "");
    }
}

