/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder.traits;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.images.builder.traits.BuildContextBuilderTrait;

public interface StringsTrait<SELF extends StringsTrait<SELF> & BuildContextBuilderTrait<SELF>> {
    default public SELF withFileFromString(String path, final String content) {
        return (SELF)((StringsTrait)((BuildContextBuilderTrait)((Object)this)).withFileFromTransferable(path, new Transferable(){
            byte[] bytes;
            {
                this.bytes = content.getBytes();
            }

            @Override
            public long getSize() {
                return this.bytes.length;
            }

            @Override
            public void transferTo(OutputStream outputStream) {
                try {
                    IOUtils.write(this.bytes, outputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't transfer string " + StringUtils.abbreviate(content, 100), e);
                }
            }
        }));
    }
}

