/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.util.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.testcontainers.shaded.io.netty.util.internal.PlatformDependent0;
import org.testcontainers.shaded.io.netty.util.internal.logging.InternalLogger;
import org.testcontainers.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

final class Cleaner0 {
    private static final long CLEANER_FIELD_OFFSET;
    private static final Method CLEAN_METHOD;
    private static final InternalLogger logger;

    static void freeDirectBuffer(ByteBuffer buffer) {
        if (CLEANER_FIELD_OFFSET == -1L || !buffer.isDirect()) {
            return;
        }
        assert (CLEAN_METHOD != null) : "CLEANER_FIELD_OFFSET != -1 implies CLEAN_METHOD != null";
        try {
            Object cleaner = PlatformDependent0.getObject(buffer, CLEANER_FIELD_OFFSET);
            if (cleaner != null) {
                CLEAN_METHOD.invoke(cleaner, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Cleaner0() {
    }

    static {
        logger = InternalLoggerFactory.getInstance(Cleaner0.class);
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        long fieldOffset = -1L;
        Method clean = null;
        if (PlatformDependent0.hasUnsafe()) {
            try {
                Field cleanerField = direct.getClass().getDeclaredField("cleaner");
                cleanerField.setAccessible(true);
                fieldOffset = PlatformDependent0.objectFieldOffset(cleanerField);
                Object cleaner = cleanerField.get(direct);
                try {
                    Runnable runnable = (Runnable)cleaner;
                    clean = Runnable.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (ClassCastException ignored) {
                    clean = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
                }
                clean.invoke(cleaner, new Object[0]);
            }
            catch (Throwable t) {
                fieldOffset = -1L;
                clean = null;
            }
        }
        logger.debug("java.nio.ByteBuffer.cleaner(): {}", (Object)(fieldOffset != -1L ? "available" : "unavailable"));
        CLEANER_FIELD_OFFSET = fieldOffset;
        CLEAN_METHOD = clean;
        Cleaner0.freeDirectBuffer(direct);
    }
}

