/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.circuitbreakers;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.Preconditions;
import org.rnorth.ducttape.circuitbreakers.Breaker;
import org.rnorth.ducttape.circuitbreakers.DefaultBreaker;
import org.rnorth.ducttape.circuitbreakers.MapBackedStateStore;
import org.rnorth.ducttape.circuitbreakers.SimpleStateStore;
import org.rnorth.ducttape.circuitbreakers.StateStore;
import org.rnorth.ducttape.circuitbreakers.TimeSource;

public class BreakerBuilder {
    private TimeSource timeSource = new TimeSource();
    private long autoResetInterval = Long.MAX_VALUE;
    private TimeUnit autoResetUnit = TimeUnit.DAYS;
    private StateStore stateStore = new SimpleStateStore();

    private BreakerBuilder() {
    }

    public static BreakerBuilder newBuilder() {
        return new BreakerBuilder();
    }

    public Breaker build() {
        return new DefaultBreaker(this.timeSource, this.autoResetInterval, this.autoResetUnit, this.stateStore);
    }

    public BreakerBuilder timeSource(@NotNull TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    public BreakerBuilder autoResetAfter(long autoResetInterval, @NotNull TimeUnit autoResetUnit) {
        Preconditions.check("reset interval must be greater than zero", autoResetInterval > 0L);
        this.autoResetInterval = autoResetInterval;
        this.autoResetUnit = autoResetUnit;
        return this;
    }

    public BreakerBuilder storeStateIn(@NotNull ConcurrentMap<String, Object> map, @NotNull String keyPrefix) {
        this.stateStore = new MapBackedStateStore(map, keyPrefix);
        return this;
    }

    public BreakerBuilder storeStateIn(@NotNull StateStore stateStore) {
        this.stateStore = stateStore;
        return this;
    }
}

