/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs.async;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.async.ResponseStreamProcessor;
import com.github.dockerjava.jaxrs.util.WrappedResponseInputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;

public abstract class AbstractCallbackNotifier<T>
implements Callable<Void> {
    private final ResponseStreamProcessor<T> responseStreamProcessor;
    private final ResultCallback<T> resultCallback;
    private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("dockerjava-jaxrs-async-%d").build();
    protected final Invocation.Builder requestBuilder;

    protected AbstractCallbackNotifier(ResponseStreamProcessor<T> responseStreamProcessor, ResultCallback<T> resultCallback, Invocation.Builder requestBuilder) {
        Preconditions.checkNotNull(requestBuilder, "An WebTarget must be provided");
        Preconditions.checkNotNull(responseStreamProcessor, "A ResponseStreamProcessor must be provided");
        this.responseStreamProcessor = responseStreamProcessor;
        this.resultCallback = resultCallback;
        this.requestBuilder = requestBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        Response response = null;
        try {
            response = this.response();
        }
        catch (ProcessingException e) {
            if (this.resultCallback == null) return null;
            this.resultCallback.onError(e.getCause());
            return null;
        }
        catch (Exception e) {
            if (this.resultCallback == null) return null;
            this.resultCallback.onError(e);
            return null;
        }
        try (WrappedResponseInputStream inputStream = new WrappedResponseInputStream(response);){
            if (this.resultCallback != null) {
                this.responseStreamProcessor.processResponseStream(inputStream, this.resultCallback);
            }
            Void void_ = null;
            return void_;
        }
        catch (Exception e) {
            if (this.resultCallback == null) return null;
            this.resultCallback.onError(e);
            return null;
        }
    }

    protected abstract Response response();

    public static <T> Future<Void> startAsyncProcessing(AbstractCallbackNotifier<T> callbackNotifier) {
        ExecutorService executorService = Executors.newSingleThreadExecutor(FACTORY);
        Future<Void> response = executorService.submit(callbackNotifier);
        executorService.shutdown();
        return response;
    }
}

