/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.dvcs;

import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.testcontainers.shaded.org.bouncycastle.asn1.cms.ContentInfo;
import org.testcontainers.shaded.org.bouncycastle.asn1.cms.SignedData;
import org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import org.testcontainers.shaded.org.bouncycastle.cms.CMSSignedData;
import org.testcontainers.shaded.org.bouncycastle.dvcs.DVCSConstructionException;
import org.testcontainers.shaded.org.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData cMSSignedData) throws DVCSConstructionException {
        this(SignedData.getInstance(cMSSignedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new DVCSConstructionException("Unable to parse content: " + exception.getMessage(), exception);
        }
    }

    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

