/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.protocol;

import java.io.IOException;
import org.testcontainers.shaded.org.apache.http.HttpEntityEnclosingRequest;
import org.testcontainers.shaded.org.apache.http.HttpException;
import org.testcontainers.shaded.org.apache.http.HttpRequest;
import org.testcontainers.shaded.org.apache.http.HttpRequestInterceptor;
import org.testcontainers.shaded.org.apache.http.annotation.ThreadSafe;
import org.testcontainers.shaded.org.apache.http.protocol.HttpContext;
import org.testcontainers.shaded.org.apache.http.protocol.HttpDateGenerator;
import org.testcontainers.shaded.org.apache.http.util.Args;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

