/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.netty.exec;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.github.dockerjava.api.command.ListContainersCmd;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Container;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersEncoder;
import org.testcontainers.shaded.com.github.dockerjava.netty.MediaType;
import org.testcontainers.shaded.com.github.dockerjava.netty.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.netty.exec.AbstrSyncDockerCmdExec;
import org.testcontainers.shaded.com.google.common.net.UrlEscapers;

public class ListContainersCmdExec
extends AbstrSyncDockerCmdExec<ListContainersCmd, List<Container>>
implements ListContainersCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListContainersCmdExec.class);

    public ListContainersCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Container> execute(ListContainersCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/containers/json").queryParam("since", command.getSinceId()).queryParam("before", command.getBeforeId());
        webTarget = this.booleanQueryParam(webTarget, "all", command.hasShowAllEnabled());
        webTarget = this.booleanQueryParam(webTarget, "size", command.hasShowSizeEnabled());
        if (command.getLimit() != null && command.getLimit() >= 0) {
            webTarget = webTarget.queryParam("limit", String.valueOf(command.getLimit()));
        }
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Container> containers = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<Container>>(){});
        LOGGER.trace("Response: {}", (Object)containers);
        return containers;
    }
}

