/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.impl.conn;

import java.io.IOException;
import java.io.OutputStream;
import org.testcontainers.shaded.org.apache.http.annotation.NotThreadSafe;
import org.testcontainers.shaded.org.apache.http.impl.conn.Wire;

@NotThreadSafe
class LoggingOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Wire wire;

    public LoggingOutputStream(OutputStream out, Wire wire) {
        this.out = out;
        this.wire = wire;
    }

    public void write(int b) throws IOException {
        this.wire.output(b);
    }

    public void write(byte[] b) throws IOException {
        this.wire.output(b);
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.wire.output(b, off, len);
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

