/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.testcontainers.shaded.org.apache.http.HttpException;
import org.testcontainers.shaded.org.apache.http.HttpHost;
import org.testcontainers.shaded.org.apache.http.HttpRequest;
import org.testcontainers.shaded.org.apache.http.annotation.ThreadSafe;
import org.testcontainers.shaded.org.apache.http.client.ClientProtocolException;
import org.testcontainers.shaded.org.apache.http.client.config.RequestConfig;
import org.testcontainers.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import org.testcontainers.shaded.org.apache.http.client.methods.Configurable;
import org.testcontainers.shaded.org.apache.http.client.methods.HttpExecutionAware;
import org.testcontainers.shaded.org.apache.http.client.methods.HttpRequestWrapper;
import org.testcontainers.shaded.org.apache.http.client.protocol.HttpClientContext;
import org.testcontainers.shaded.org.apache.http.conn.ClientConnectionManager;
import org.testcontainers.shaded.org.apache.http.conn.ClientConnectionRequest;
import org.testcontainers.shaded.org.apache.http.conn.HttpClientConnectionManager;
import org.testcontainers.shaded.org.apache.http.conn.ManagedClientConnection;
import org.testcontainers.shaded.org.apache.http.conn.routing.HttpRoute;
import org.testcontainers.shaded.org.apache.http.conn.scheme.SchemeRegistry;
import org.testcontainers.shaded.org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.testcontainers.shaded.org.apache.http.impl.client.CloseableHttpClient;
import org.testcontainers.shaded.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.testcontainers.shaded.org.apache.http.impl.execchain.MinimalClientExec;
import org.testcontainers.shaded.org.apache.http.params.BasicHttpParams;
import org.testcontainers.shaded.org.apache.http.params.HttpParams;
import org.testcontainers.shaded.org.apache.http.protocol.BasicHttpContext;
import org.testcontainers.shaded.org.apache.http.protocol.HttpContext;
import org.testcontainers.shaded.org.apache.http.protocol.HttpRequestExecutor;
import org.testcontainers.shaded.org.apache.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

