/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.testcontainers.containers.output.OutputFrame;

public class Slf4jLogConsumer
implements Consumer<OutputFrame> {
    private final Logger logger;
    private String prefix = "";

    public Slf4jLogConsumer(Logger logger) {
        this.logger = logger;
    }

    public Slf4jLogConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    @Override
    public void accept(OutputFrame outputFrame) {
        String utf8String;
        if (outputFrame != null && (utf8String = outputFrame.getUtf8String()) != null) {
            this.logger.info("{}{}: {}", new Object[]{this.prefix, outputFrame.getType(), utf8String.trim()});
        }
    }
}

