/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import lombok.NonNull;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.WaitStrategy;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Bind;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Info;

public interface Container<SELF extends Container<SELF>>
extends LinkableContainer {
    default public SELF self() {
        return (SELF)this;
    }

    public void setCommand(@NonNull String var1);

    public void setCommand(String ... var1);

    public void addEnv(String var1, String var2);

    public void addFileSystemBind(String var1, String var2, BindMode var3);

    public void addLink(LinkableContainer var1, String var2);

    public void addExposedPort(Integer var1);

    public void addExposedPorts(int ... var1);

    public SELF waitingFor(@NonNull WaitStrategy var1);

    public SELF withFileSystemBind(String var1, String var2, BindMode var3);

    public SELF withExposedPorts(Integer ... var1);

    public SELF withEnv(String var1, String var2);

    public SELF withEnv(Map<String, String> var1);

    public SELF withCommand(String var1);

    public SELF withCommand(String ... var1);

    public SELF withExtraHost(String var1, String var2);

    public SELF withNetworkMode(String var1);

    public SELF withClasspathResourceMapping(String var1, String var2, BindMode var3);

    public SELF withStartupTimeout(Duration var1);

    public String getContainerIpAddress();

    public SELF withMinimumRunningDuration(Duration var1);

    public Boolean isRunning();

    public Integer getMappedPort(int var1);

    public void setDockerImageName(@NonNull String var1);

    @NonNull
    public String getDockerImageName();

    public String getTestHostIpAddress();

    public void followOutput(Consumer<OutputFrame> var1);

    public void followOutput(Consumer<OutputFrame> var1, OutputFrame.OutputType ... var2);

    public Info fetchDockerDaemonInfo() throws IOException;

    public ExecResult execInContainer(String ... var1) throws UnsupportedOperationException, IOException, InterruptedException;

    public ExecResult execInContainer(Charset var1, String ... var2) throws UnsupportedOperationException, IOException, InterruptedException;

    public List<Integer> getExposedPorts();

    public List<String> getPortBindings();

    public List<String> getExtraHosts();

    public Future<String> getImage();

    public List<String> getEnv();

    public String[] getCommandParts();

    public List<Bind> getBinds();

    public Map<String, LinkableContainer> getLinkedContainers();

    public DockerClient getDockerClient();

    public Info getDockerDaemonInfo();

    public String getContainerId();

    @Override
    public String getContainerName();

    public InspectContainerResponse getContainerInfo();

    public void setExposedPorts(List<Integer> var1);

    public void setPortBindings(List<String> var1);

    public void setExtraHosts(List<String> var1);

    public void setImage(Future<String> var1);

    public void setEnv(List<String> var1);

    public void setCommandParts(String[] var1);

    public void setBinds(List<Bind> var1);

    public void setLinkedContainers(Map<String, LinkableContainer> var1);

    public void setDockerClient(DockerClient var1);

    public void setDockerDaemonInfo(Info var1);

    public void setContainerId(String var1);

    public void setContainerName(String var1);

    public void setWaitStrategy(WaitStrategy var1);

    public void setContainerInfo(InspectContainerResponse var1);

    public static class ExecResult {
        private final String stdout;
        private final String stderr;

        public ExecResult(String stdout, String stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }
    }
}

