/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.junit;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.AbstractContainer;
import org.testcontainers.containers.BrowserWebDriverContainer;
import org.testcontainers.containers.VncRecordingSidekickContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.traits.LinkableContainerRule;
import org.testcontainers.containers.traits.VncService;
import org.testcontainers.utility.CommandLine;

public class BrowserWebDriverContainerRule
extends TestWatcher {
    private final Collection<AbstractContainer> containers = new ArrayList<AbstractContainer>();
    private final Collection<RemoteWebDriver> drivers = new ArrayList<RemoteWebDriver>();
    private final DesiredCapabilities desiredCapabilities;
    private final Map<RemoteWebDriver, String> vncUrls = new HashMap<RemoteWebDriver, String>();
    private final Map<RemoteWebDriver, URL> seleniumUrls = new HashMap<RemoteWebDriver, URL>();
    private final VncRecordingMode recordingMode;
    private final File vncRecordingDirectory;
    private Collection<VncRecordingSidekickContainer> currentVncRecordings = new ArrayList<VncRecordingSidekickContainer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserWebDriverContainerRule.class);
    private static final SimpleDateFormat filenameDateFormat = new SimpleDateFormat("YYYYMMdd-HHmmss");
    private Map<String, LinkableContainerRule> containerRulesToLink = new HashMap<String, LinkableContainerRule>();

    public BrowserWebDriverContainerRule(DesiredCapabilities desiredCapabilities) {
        this(desiredCapabilities, VncRecordingMode.SKIP, null);
    }

    public BrowserWebDriverContainerRule(DesiredCapabilities desiredCapabilities, VncRecordingMode recordingMode, File vncRecordingDirectory) {
        this.desiredCapabilities = desiredCapabilities;
        this.recordingMode = recordingMode;
        this.vncRecordingDirectory = vncRecordingDirectory;
    }

    public RemoteWebDriver newDriver() {
        HashMap<String, LinkableContainer> containersToLink = new HashMap<String, LinkableContainer>();
        for (Map.Entry<String, LinkableContainerRule> entry : this.containerRulesToLink.entrySet()) {
            containersToLink.put(entry.getKey(), entry.getValue().getContainer());
        }
        BrowserWebDriverContainer container = new BrowserWebDriverContainer(this.desiredCapabilities, containersToLink);
        this.containers.add(container);
        container.start();
        try {
            RemoteWebDriver driver = new RemoteWebDriver(container.getSeleniumAddress(), (Capabilities)this.desiredCapabilities);
            this.drivers.add(driver);
            this.vncUrls.put(driver, container.getVncAddress());
            this.seleniumUrls.put(driver, container.getSeleniumAddress());
            if (this.recordingMode != VncRecordingMode.SKIP) {
                LOGGER.debug("Starting VNC recording");
                VncRecordingSidekickContainer recordingSidekickContainer = new VncRecordingSidekickContainer((VncService)container);
                recordingSidekickContainer.start();
                this.currentVncRecordings.add(recordingSidekickContainer);
            }
            return driver;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not determine webdriver URL", e);
        }
    }

    protected void failed(Throwable e, Description description) {
        switch (this.recordingMode) {
            case RECORD_FAILING: 
            case RECORD_ALL: {
                this.stopAndRetainRecording(description);
            }
        }
        this.currentVncRecordings.clear();
    }

    protected void succeeded(Description description) {
        switch (this.recordingMode) {
            case RECORD_ALL: {
                this.stopAndRetainRecording(description);
            }
        }
        this.currentVncRecordings.clear();
    }

    protected void finished(Description description) {
        for (RemoteWebDriver driver : this.drivers) {
            driver.quit();
        }
        for (AbstractContainer container : this.containers) {
            container.stop();
        }
    }

    private void stopAndRetainRecording(Description description) {
        File recordingFile = new File(this.vncRecordingDirectory, "recording-" + filenameDateFormat.format(new Date()) + ".flv");
        LOGGER.info("Screen recordings for test {} will be stored at: {}", (Object)description.getDisplayName(), (Object)recordingFile);
        for (VncRecordingSidekickContainer container : this.currentVncRecordings) {
            container.stopAndRetainRecording(recordingFile);
        }
    }

    public String getHostIpAddress() {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            try {
                Preconditions.checkArgument((boolean)CommandLine.executableExists((String)"/usr/local/bin/boot2docker"), (Object)"boot2docker must be installed for use on OS X");
                CommandLine.runShellCommand((String[])new String[]{"/usr/local/bin/boot2docker", "up"});
                String boot2dockerConfig = CommandLine.runShellCommand((String[])new String[]{"/usr/local/bin/boot2docker", "config"});
                for (String line : boot2dockerConfig.split("\n")) {
                    Matcher matcher = Pattern.compile("HostIP = \"(.+)\"").matcher(line);
                    if (!matcher.matches()) continue;
                    return matcher.group(1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new UnsupportedOperationException("This is only implemented for boot2docker right now");
        }
        throw new UnsupportedOperationException();
    }

    public String getVncUrl(RemoteWebDriver driver) {
        return this.vncUrls.get(driver);
    }

    public URL getSeleniumURL(RemoteWebDriver driver) {
        return this.seleniumUrls.get(driver);
    }

    public BrowserWebDriverContainerRule withLinkToContainer(LinkableContainerRule containerRule, String alias) {
        this.containerRulesToLink.put(alias, containerRule);
        return this;
    }

    public static enum VncRecordingMode {
        SKIP,
        RECORD_ALL,
        RECORD_FAILING;

    }
}

