/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class PulsarContainer
extends GenericContainer<PulsarContainer> {
    public static final int PULSAR_PORT = 6850;

    public PulsarContainer() {
        this("2.0.1-incubating");
    }

    public PulsarContainer(String pulsarVersion) {
        super(TestcontainersConfiguration.getInstance().getPulsarImage() + ":" + pulsarVersion);
        this.withExposedPorts(new Integer[]{6850});
        this.withCommand(new String[]{"/bin/bash", "-c", "servicePort=6850 webServicePort=8280 webServicePortTls=8643 bin/apply-config-from-env.py conf/proxy.conf && bin/pulsar standalone & bin/pulsar proxy --zookeeper-servers localhost:2181 --global-zookeeper-servers localhost:2181"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*messaging service is ready.*\\s", (int)1));
    }

    public String getPulsarBrokerUrl() {
        return String.format("pulsar://%s:%s", this.getContainerIpAddress(), this.getFirstMappedPort());
    }
}

