/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class PulsarContainer
extends GenericContainer<PulsarContainer> {
    public static final int BROKER_PORT = 6650;
    public static final int BROKER_HTTP_PORT = 8080;
    public static final String METRICS_ENDPOINT = "/metrics";
    private static final String PULSAR_VERSION = "2.2.0";

    public PulsarContainer() {
        this(PULSAR_VERSION);
    }

    public PulsarContainer(String pulsarVersion) {
        super(TestcontainersConfiguration.getInstance().getPulsarImage() + ":" + pulsarVersion);
        this.withExposedPorts(new Integer[]{6650, 8080});
        this.withCommand(new String[]{"/pulsar/bin/pulsar", "standalone", "--no-functions-worker", "-nss"});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)METRICS_ENDPOINT).forStatusCode(200).forPort(8080));
    }

    public String getPulsarBrokerUrl() {
        return String.format("pulsar://%s:%s", this.getHost(), this.getMappedPort(6650));
    }

    public String getHttpServiceUrl() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8080));
    }
}

