/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.PostgreSQLR2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainerProvider;

public final class PostgreSQLR2DBCDatabaseContainerProvider
implements R2DBCDatabaseContainerProvider {
    static final String DRIVER = "postgresql";

    public boolean supports(ConnectionFactoryOptions options) {
        return DRIVER.equals(options.getRequiredValue(ConnectionFactoryOptions.DRIVER));
    }

    public R2DBCDatabaseContainer createContainer(ConnectionFactoryOptions options) {
        String image = "postgres:" + (String)options.getRequiredValue(IMAGE_TAG_OPTION);
        JdbcDatabaseContainer container = new PostgreSQLContainer(image).withDatabaseName((String)options.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        if (Boolean.TRUE.equals(options.getValue(REUSABLE_OPTION))) {
            container.withReuse(true);
        }
        return new PostgreSQLR2DBCDatabaseContainer((PostgreSQLContainer<?>)container);
    }
}

