/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.TestcontainersConfiguration;

public class OracleContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "oracle";
    public static final String IMAGE = TestcontainersConfiguration.getInstance().getProperties().getProperty("oracle.container.image", "wnameless/oracle-xe-11g");
    private static final int ORACLE_PORT = 1521;
    private static final int APEX_HTTP_PORT = 8080;

    public OracleContainer() {
        super(IMAGE + ":latest");
    }

    public OracleContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(1521);
    }

    protected void configure() {
        this.addExposedPorts(new int[]{1521, 8080});
    }

    public String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:oracle:thin:" + this.getUsername() + "/" + this.getPassword() + "@//" + this.getContainerIpAddress() + ":" + this.getOraclePort() + "/" + this.getSid();
    }

    public String getUsername() {
        return "system";
    }

    public String getPassword() {
        return NAME;
    }

    public String getSid() {
        return "xe";
    }

    public Integer getOraclePort() {
        return this.getMappedPort(1521);
    }

    public Integer getWebPort() {
        return this.getMappedPort(8080);
    }

    public String getTestQueryString() {
        return "SELECT 1 FROM DUAL";
    }
}

