/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class OracleContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "oracle";
    public static final String IMAGE = "wnameless/oracle-xe-11g";
    private String sshPort;
    private String oraclePort;
    private String webPort;

    public OracleContainer() {
        super("wnameless/oracle-xe-11g:latest");
    }

    public OracleContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected void containerIsStarting(ContainerInfo containerInfo) {
        this.sshPort = ((PortBinding)((List)containerInfo.networkSettings().ports().get("22/tcp")).get(0)).hostPort();
        this.oraclePort = ((PortBinding)((List)containerInfo.networkSettings().ports().get("1521/tcp")).get(0)).hostPort();
        this.webPort = ((PortBinding)((List)containerInfo.networkSettings().ports().get("8080/tcp")).get(0)).hostPort();
    }

    protected String getLivenessCheckPort() {
        return this.oraclePort;
    }

    protected ContainerConfig getContainerConfig() {
        return ContainerConfig.builder().image(this.getDockerImageName()).exposedPorts(new String[]{"22", "1521", "8080"}).build();
    }

    protected String getDockerImageName() {
        return "wnameless/oracle-xe-11g:" + this.tag;
    }

    public String getName() {
        return NAME;
    }

    public String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:oracle:thin:" + this.getUsername() + "/" + this.getPassword() + "@//" + this.dockerHostIpAddress + ":" + this.oraclePort + "/" + this.getSid();
    }

    public String getUsername() {
        return "system";
    }

    public String getPassword() {
        return NAME;
    }

    public String getSid() {
        return "xe";
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public String getOraclePort() {
        return this.oraclePort;
    }

    public String getWebPort() {
        return this.webPort;
    }

    public String getTestQueryString() {
        return "SELECT 1 FROM DUAL";
    }
}

