/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class MySQLContainer<SELF extends MySQLContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "mysql";
    public static final String IMAGE = "mysql";
    private static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";
    public static final Integer MYSQL_PORT = 3306;
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";

    public MySQLContainer() {
        super("mysql:latest");
    }

    public MySQLContainer(String dockerImageName) {
        super(dockerImageName);
    }

    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return new HashSet<Integer>(this.getMappedPort(MYSQL_PORT));
    }

    protected void configure() {
        this.optionallyMapResourceParameterAsVolume(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, "/etc/mysql/conf.d", "mysql-default-conf");
        this.addExposedPort(MYSQL_PORT);
        this.addEnv("MYSQL_DATABASE", this.databaseName);
        this.addEnv("MYSQL_USER", this.username);
        this.addEnv("MYSQL_PASSWORD", this.password);
        this.addEnv("MYSQL_ROOT_PASSWORD", "test");
        this.setStartupAttempts(3);
    }

    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:mysql://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MYSQL_PORT) + "/" + this.databaseName;
    }

    protected String constructUrlForConnection(String queryString) {
        String url = super.constructUrlForConnection(queryString);
        if (!url.contains("useSSL=")) {
            String separator = url.contains("?") ? "&" : "?";
            return url + separator + "useSSL=false";
        }
        return url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withConfigurationOverride(String s) {
        this.parameters.put(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, s);
        return (SELF)((Object)((MySQLContainer)this.self()));
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((MySQLContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((MySQLContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((MySQLContainer)this.self()));
    }
}

