/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;

public class MySQLContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "mysql";
    public static final String IMAGE = "mysql";
    private static final String MY_CNF_CONFIG_OVERRIDE_PARAM_NAME = "TC_MY_CNF";
    private static final Integer MYSQL_PORT = 3306;

    public MySQLContainer() {
        super("mysql:latest");
    }

    public MySQLContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(MYSQL_PORT);
    }

    protected void configure() {
        this.optionallyMapResourceParameterAsVolume(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, "/etc/mysql/conf.d");
        this.addExposedPort(3306);
        this.addEnv("MYSQL_DATABASE", "test");
        this.addEnv("MYSQL_USER", "test");
        this.addEnv("MYSQL_PASSWORD", "test");
        this.addEnv("MYSQL_ROOT_PASSWORD", "test");
        this.setCommand("mysqld");
    }

    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:mysql://" + this.getIpAddress() + ":" + this.getMappedPort(MYSQL_PORT) + "/test";
    }

    public String getUsername() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public MySQLContainer withConfigurationOverride(String s) {
        this.parameters.put(MY_CNF_CONFIG_OVERRIDE_PARAM_NAME, s);
        return this;
    }
}

