/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class MySQLContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "mysql";
    public static final String IMAGE = "mysql";
    private String mySqlPort;

    public MySQLContainer() {
        super("mysql:latest");
    }

    public MySQLContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected void containerIsStarting(ContainerInfo containerInfo) {
        this.mySqlPort = ((PortBinding)((List)containerInfo.networkSettings().ports().get("3306/tcp")).get(0)).hostPort();
    }

    protected String getLivenessCheckPort() {
        return this.mySqlPort;
    }

    protected ContainerConfig getContainerConfig() {
        return ContainerConfig.builder().image(this.getDockerImageName()).exposedPorts(new String[]{"3306"}).env(new String[]{"MYSQL_DATABASE=test", "MYSQL_USER=test", "MYSQL_PASSWORD=test", "MYSQL_ROOT_PASSWORD=test"}).cmd(new String[]{"mysqld"}).build();
    }

    public String getName() {
        return "mysql";
    }

    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:mysql://" + this.dockerHostIpAddress + ":" + this.mySqlPort + "/test";
    }

    public String getUsername() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }
}

