/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.LicenseAcceptance;

public class MSSQLServerContainer<SELF extends MSSQLServerContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "sqlserver";
    public static final String IMAGE = "mcr.microsoft.com/mssql/server";
    public static final String DEFAULT_TAG = "2017-CU12";
    public static final Integer MS_SQL_SERVER_PORT = 1433;
    private String username = "SA";
    private String password = "A_Str0ng_Required_Password";
    private static final int DEFAULT_STARTUP_TIMEOUT_SECONDS = 240;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 240;

    public MSSQLServerContainer() {
        this("mcr.microsoft.com/mssql/server:2017-CU12");
    }

    public MSSQLServerContainer(String dockerImageName) {
        super(dockerImageName);
        this.withStartupTimeoutSeconds(240);
        this.withConnectTimeoutSeconds(240);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(MS_SQL_SERVER_PORT);
    }

    protected void configure() {
        this.addExposedPort(MS_SQL_SERVER_PORT);
        LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
        this.addEnv("ACCEPT_EULA", "Y");
        this.addEnv("SA_PASSWORD", this.password);
    }

    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:sqlserver://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MS_SQL_SERVER_PORT);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }
}

