/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class MockServerContainer
extends GenericContainer<MockServerContainer> {
    private static final Logger log = LoggerFactory.getLogger(MockServerContainer.class);
    public static final String VERSION = "5.5.4";
    public static final int PORT = 1080;

    @Deprecated
    public MockServerContainer() {
        this(VERSION);
    }

    @Deprecated
    public MockServerContainer(String version) {
        this(DockerImageName.parse((String)("jamesdbloom/mockserver:mockserver-" + version)));
    }

    public MockServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.withCommand("-logLevel INFO -serverPort 1080");
        this.addExposedPorts(new int[]{1080});
    }

    public String getEndpoint() {
        return String.format("http://%s:%d", this.getHost(), this.getMappedPort(1080));
    }

    public Integer getServerPort() {
        return this.getMappedPort(1080);
    }
}

