/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.localstack;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.rnorth.ducttape.Preconditions;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.WaitStrategy;

public class LocalStackContainer
extends ExternalResource {
    @Nullable
    private GenericContainer delegate;
    private Service[] services;

    protected void before() throws Throwable {
        Preconditions.check((String)"services list must not be empty", (this.services != null && this.services.length > 0 ? 1 : 0) != 0);
        String servicesList = Arrays.stream(this.services).map(Service::getLocalStackName).collect(Collectors.joining(","));
        Integer[] portsList = Arrays.stream(this.services).map(Service::getPort).collect(Collectors.toSet()).toArray(new Integer[0]);
        this.delegate = new GenericContainer("atlassianlabs/localstack:0.6.0").withExposedPorts(portsList).withFileSystemBind("/var/run/docker.sock", "/var/run/docker.sock", BindMode.READ_WRITE).waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Ready\\.\n")).withEnv("SERVICES", servicesList);
        this.delegate.start();
    }

    protected void after() {
        Preconditions.check((String)"delegate must have been created by before()", (this.delegate != null ? 1 : 0) != 0);
        this.delegate.stop();
    }

    public LocalStackContainer withServices(Service ... services) {
        this.services = services;
        return this;
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(Service service) {
        String address;
        if (this.delegate == null) {
            throw new IllegalStateException("LocalStack has not been started yet!");
        }
        String ipAddress = address = this.delegate.getContainerIpAddress();
        try {
            ipAddress = InetAddress.getByName(address).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        ipAddress = ipAddress + ".xip.io";
        while (true) {
            try {
                InetAddress.getAllByName(ipAddress);
            }
            catch (UnknownHostException unknownHostException) {
                continue;
            }
            break;
        }
        return new AwsClientBuilder.EndpointConfiguration("http://" + ipAddress + ":" + this.delegate.getMappedPort(service.getPort().intValue()), "us-east-1");
    }

    public AWSCredentialsProvider getDefaultCredentialsProvider() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("accesskey", "secretkey"));
    }

    public static enum Service {
        API_GATEWAY("apigateway", 4567),
        KINESIS("kinesis", 4568),
        DYNAMODB("dynamodb", 4569),
        DYNAMODB_STREAMS("dynamodbstreams", 4570),
        S3("s3", 4572),
        FIREHOSE("firehose", 4573),
        LAMBDA("lambda", 4574),
        SNS("sns", 4575),
        SQS("sqs", 4576),
        REDSHIFT("redshift", 4577),
        SES("ses", 4579),
        ROUTE53("route53", 4580),
        CLOUDFORMATION("cloudformation", 4581),
        CLOUDWATCH("cloudwatch", 4582);

        private final String localStackName;
        private final int port;

        private Service(String localstackName, int port) {
            this.localStackName = localstackName;
            this.port = port;
        }

        public String getLocalStackName() {
            return this.localStackName;
        }

        public Integer getPort() {
            return this.port;
        }
    }
}

