/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.localstack;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.rnorth.ducttape.Preconditions;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class LocalStackContainer
extends GenericContainer<LocalStackContainer> {
    public static final String VERSION = "0.9.4";
    private final List<Service> services = new ArrayList<Service>();

    public LocalStackContainer() {
        this(VERSION);
    }

    public LocalStackContainer(String version) {
        super("localstack/localstack:" + version);
        this.withFileSystemBind("//var/run/docker.sock", "/var/run/docker.sock");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready\\.\n", (int)1));
    }

    protected void configure() {
        super.configure();
        Preconditions.check((String)"services list must not be empty", (!this.services.isEmpty() ? 1 : 0) != 0);
        this.withEnv("SERVICES", this.services.stream().map(Service::getLocalStackName).collect(Collectors.joining(",")));
        for (Service service : this.services) {
            this.addExposedPort(service.getPort());
        }
    }

    public LocalStackContainer withServices(Service ... services) {
        this.services.addAll(Arrays.asList(services));
        return (LocalStackContainer)this.self();
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(Service service) {
        String address;
        String ipAddress = address = this.getContainerIpAddress();
        try {
            ipAddress = InetAddress.getByName(address).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return new AwsClientBuilder.EndpointConfiguration("http://" + ipAddress + ":" + this.getMappedPort(service.getPort()), "us-east-1");
    }

    public AWSCredentialsProvider getDefaultCredentialsProvider() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("accesskey", "secretkey"));
    }

    public static enum Service {
        API_GATEWAY("apigateway", 4567),
        KINESIS("kinesis", 4568),
        DYNAMODB("dynamodb", 4569),
        DYNAMODB_STREAMS("dynamodbstreams", 4570),
        S3("s3", 4572),
        FIREHOSE("firehose", 4573),
        LAMBDA("lambda", 4574),
        SNS("sns", 4575),
        SQS("sqs", 4576),
        REDSHIFT("redshift", 4577),
        SES("ses", 4579),
        ROUTE53("route53", 4580),
        CLOUDFORMATION("cloudformation", 4581),
        CLOUDWATCH("cloudwatch", 4582),
        SSM("ssm", 4583),
        SECRETSMANAGER("secretsmanager", 4584),
        STEPFUNCTIONS("stepsfunctions", 4585),
        CLOUDWATCHLOGS("cloudwatchlogs", 4586),
        STS("sts", 4592),
        IAM("iam", 4593);

        final String localStackName;
        final int port;

        private Service(String localStackName, int port) {
            this.localStackName = localStackName;
            this.port = port;
        }

        public String getLocalStackName() {
            return this.localStackName;
        }

        public int getPort() {
            return this.port;
        }
    }
}

