/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class KafkaContainer
extends GenericContainer<KafkaContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"confluentinc/cp-kafka");
    private static final String DEFAULT_TAG = "5.4.3";
    public static final int KAFKA_PORT = 9093;
    public static final int ZOOKEEPER_PORT = 2181;
    private static final String DEFAULT_INTERNAL_TOPIC_RF = "1";
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";
    private static final String MIN_KRAFT_TAG = "7.0.0";
    protected String externalZookeeperConnect = null;
    private boolean kraftEnabled = false;
    private String clusterId;

    @Deprecated
    public KafkaContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    @Deprecated
    public KafkaContainer(String confluentPlatformVersion) {
        this(DEFAULT_IMAGE_NAME.withTag(confluentPlatformVersion));
    }

    public KafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092");
        this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        this.withEnv("KAFKA_BROKER_ID", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_OFFSETS_TOPIC_NUM_PARTITIONS", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_LOG_FLUSH_INTERVAL_MESSAGES", "9223372036854775807");
        this.withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0");
        this.withExposedPorts(new Integer[]{9093});
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"sh"}));
        this.withCommand(new String[]{"-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
    }

    public KafkaContainer withEmbeddedZookeeper() {
        if (this.kraftEnabled) {
            throw new IllegalStateException("Cannot configure Zookeeper when using Kraft mode");
        }
        this.externalZookeeperConnect = null;
        return (KafkaContainer)this.self();
    }

    public KafkaContainer withExternalZookeeper(String connectString) {
        if (this.kraftEnabled) {
            throw new IllegalStateException("Cannot configure Zookeeper when using Kraft mode");
        }
        this.externalZookeeperConnect = connectString;
        return (KafkaContainer)this.self();
    }

    public KafkaContainer withKraft() {
        if (this.externalZookeeperConnect != null) {
            throw new IllegalStateException("Cannot configure Kraft mode when Zookeeper configured");
        }
        this.verifyMinKraftVersion();
        this.kraftEnabled = true;
        return (KafkaContainer)this.self();
    }

    private void verifyMinKraftVersion() {
        String actualVersion = DockerImageName.parse((String)this.getDockerImageName()).getVersionPart();
        if (new ComparableVersion(actualVersion).isLessThan(MIN_KRAFT_TAG)) {
            throw new IllegalArgumentException(String.format("Provided Confluent Platform's version %s is not supported in Kraft mode (must be %s or above)", actualVersion, MIN_KRAFT_TAG));
        }
    }

    public KafkaContainer withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return (KafkaContainer)this.self();
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9093));
    }

    protected void configure() {
        if (this.kraftEnabled) {
            this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Transitioning from RECOVERY to RUNNING.*", (int)1));
            this.configureKraft();
        } else {
            this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*\\[KafkaServer id=\\d+\\] started.*", (int)1));
            this.configureZookeeper();
        }
    }

    protected void configureKraft() {
        this.withEnv("KAFKA_NODE_ID", this.getEnvMap().computeIfAbsent("KAFKA_NODE_ID", key -> (String)this.getEnvMap().get("KAFKA_BROKER_ID")));
        this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", String.format("%s,CONTROLLER:PLAINTEXT", this.getEnvMap().get("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP")));
        this.withEnv("KAFKA_LISTENERS", String.format("%s,CONTROLLER://0.0.0.0:9094", this.getEnvMap().get("KAFKA_LISTENERS")));
        this.withEnv("KAFKA_PROCESS_ROLES", "broker,controller");
        this.withEnv("KAFKA_CONTROLLER_QUORUM_VOTERS", this.getEnvMap().computeIfAbsent("KAFKA_CONTROLLER_QUORUM_VOTERS", key -> String.format("%s@%s:9094", this.getEnvMap().get("KAFKA_NODE_ID"), this.getNetwork() != null ? this.getNetworkAliases().get(0) : "localhost")));
        this.withEnv("KAFKA_CONTROLLER_LISTENER_NAMES", "CONTROLLER");
    }

    protected void configureZookeeper() {
        if (this.externalZookeeperConnect != null) {
            this.withEnv("KAFKA_ZOOKEEPER_CONNECT", this.externalZookeeperConnect);
        } else {
            this.addExposedPort(2181);
            this.withEnv("KAFKA_ZOOKEEPER_CONNECT", "localhost:2181");
        }
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        super.containerIsStarting(containerInfo);
        String command = "#!/bin/bash\n";
        command = command + String.format("export KAFKA_ADVERTISED_LISTENERS=%s,%s\n", this.getBootstrapServers(), this.brokerAdvertisedListener(containerInfo));
        command = command + (this.kraftEnabled ? this.commandKraft() : this.commandZookeeper());
        command = command + "echo '' > /etc/confluent/docker/ensure \n";
        command = command + "/etc/confluent/docker/run \n";
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    protected String commandKraft() {
        String command = "sed -i '/KAFKA_ZOOKEEPER_CONNECT/d' /etc/confluent/docker/configure\n";
        try {
            if (this.clusterId == null) {
                this.clusterId = this.execInContainer(new String[]{"kafka-storage", "random-uuid"}).getStdout().trim();
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger().error("Failed to execute `kafka-storage random-uuid`. Exception message: {}", (Object)e.getMessage());
        }
        command = command + "echo 'kafka-storage format --ignore-formatted -t \"" + this.clusterId + "\" -c /etc/kafka/kafka.properties' >> /etc/confluent/docker/configure\n";
        return command;
    }

    protected String commandZookeeper() {
        String command = "echo 'clientPort=2181' > zookeeper.properties\n";
        command = command + "echo 'dataDir=/var/lib/zookeeper/data' >> zookeeper.properties\n";
        command = command + "echo 'dataLogDir=/var/lib/zookeeper/log' >> zookeeper.properties\n";
        command = command + "zookeeper-server-start zookeeper.properties &\n";
        return command;
    }

    protected String brokerAdvertisedListener(InspectContainerResponse containerInfo) {
        return String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9092");
    }
}

