/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.MountableFile;

public abstract class JdbcDatabaseContainer<SELF extends JdbcDatabaseContainer<SELF>>
extends GenericContainer<SELF>
implements LinkableContainer {
    private static final Object DRIVER_LOAD_MUTEX = new Object();
    private Driver driver;
    private String initScriptPath;
    protected Map<String, String> parameters = new HashMap<String, String>();
    private int startupTimeoutSeconds = 120;
    private int connectTimeoutSeconds = 120;

    public JdbcDatabaseContainer(@NonNull String dockerImageName) {
        super(dockerImageName);
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked @NonNull but is null");
        }
    }

    public JdbcDatabaseContainer(@NonNull Future<String> image) {
        super(image);
        if (image == null) {
            throw new NullPointerException("image is marked @NonNull but is null");
        }
    }

    public abstract String getDriverClassName();

    public abstract String getJdbcUrl();

    public String getDatabaseName() {
        throw new UnsupportedOperationException();
    }

    public abstract String getUsername();

    public abstract String getPassword();

    protected abstract String getTestQueryString();

    public SELF withUsername(String username) {
        throw new UnsupportedOperationException();
    }

    public SELF withPassword(String password) {
        throw new UnsupportedOperationException();
    }

    public SELF withDatabaseName(String dbName) {
        throw new UnsupportedOperationException();
    }

    public SELF withStartupTimeoutSeconds(int startupTimeoutSeconds) {
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    public SELF withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    public SELF withInitScript(String initScriptPath) {
        this.initScriptPath = initScriptPath;
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    protected void waitUntilContainerStarted() {
        this.logger().info("Waiting for database connection to become available at {} using query '{}'", (Object)this.getJdbcUrl(), (Object)this.getTestQueryString());
        long start = System.currentTimeMillis();
        block16: while (true) {
            try {
                while (System.currentTimeMillis() < start + (long)(1000 * this.startupTimeoutSeconds)) {
                    try {
                        if (!this.isRunning()) {
                            Thread.sleep(100L);
                            continue;
                        }
                        Connection connection = this.createConnection("");
                        Throwable throwable = null;
                        try {
                            boolean testQuerySucceeded = connection.createStatement().execute(this.getTestQueryString());
                            if (!testQuerySucceeded) continue block16;
                            break block16;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (connection == null) continue block16;
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue block16;
                            }
                            connection.close();
                            continue block16;
                        }
                    }
                    catch (NoDriverFoundException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.logger().debug("Failure when trying test query", (Throwable)e);
                        Thread.sleep(100L);
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ContainerLaunchException("Container startup wait was interrupted", (Throwable)e);
            }
        }
        this.logger().info("Container is started (JDBC URL: {})", (Object)this.getJdbcUrl());
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.runInitScriptIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver getJdbcDriverInstance() throws NoDriverFoundException {
        Object object = DRIVER_LOAD_MUTEX;
        synchronized (object) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)Class.forName(this.getDriverClassName()).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new NoDriverFoundException("Could not get Driver", e);
                }
            }
        }
        return this.driver;
    }

    public Connection createConnection(String queryString) throws SQLException, NoDriverFoundException {
        Properties info = new Properties();
        info.put("user", this.getUsername());
        info.put("password", this.getPassword());
        String url = this.constructUrlForConnection(queryString);
        Driver jdbcDriverInstance = this.getJdbcDriverInstance();
        SQLException lastException = null;
        try {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + (long)(1000 * this.connectTimeoutSeconds) && this.isRunning()) {
                try {
                    this.logger().debug("Trying to create JDBC connection using {} to {} with properties: {}", new Object[]{this.driver.getClass().getName(), url, info});
                    return jdbcDriverInstance.connect(url, info);
                }
                catch (SQLException e) {
                    lastException = e;
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new SQLException("Could not create new connection", lastException);
    }

    protected String constructUrlForConnection(String queryString) {
        return this.getJdbcUrl() + queryString;
    }

    protected void optionallyMapResourceParameterAsVolume(@NotNull String paramName, @NotNull String pathNameInContainer, @NotNull String defaultResource) {
        String resourceName = this.parameters.getOrDefault(paramName, defaultResource);
        if (resourceName != null) {
            MountableFile mountableFile = MountableFile.forClasspathResource((String)resourceName);
            this.withCopyFileToContainer(mountableFile, pathNameInContainer);
        }
    }

    protected void runInitScriptIfRequired() {
        if (this.initScriptPath != null) {
            ScriptUtils.runInitScript((DatabaseDelegate)this.getDatabaseDelegate(), (String)this.initScriptPath);
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String paramName, String value) {
        this.parameters.put(paramName, value);
    }

    @Deprecated
    protected int getStartupTimeoutSeconds() {
        return this.startupTimeoutSeconds;
    }

    @Deprecated
    protected int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    protected DatabaseDelegate getDatabaseDelegate() {
        return new JdbcDatabaseDelegate(this, "");
    }

    public static class NoDriverFoundException
    extends RuntimeException {
        public NoDriverFoundException(String message, Throwable e) {
            super(message, e);
        }
    }
}

