/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io.tar;

import java.io.File;
import java.util.Date;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io.tar.InvalidHeaderException;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.io.tar.TarHeader;

public class TarEntry
implements Cloneable {
    protected File file;
    protected TarHeader header;
    protected boolean unixFormat;
    protected boolean ustarFormat;
    protected boolean gnuFormat;

    protected TarEntry() {
    }

    public TarEntry(String name) {
        this.initialize();
        this.nameTarHeader(this.header, name);
    }

    public TarEntry(File file) throws InvalidHeaderException {
        this.initialize();
        this.getFileTarHeader(this.header, file);
    }

    public TarEntry(byte[] headerBuf) throws InvalidHeaderException {
        this.initialize();
        this.parseTarHeader(this.header, headerBuf);
    }

    private void initialize() {
        this.file = null;
        this.header = new TarHeader();
        this.gnuFormat = false;
        this.ustarFormat = true;
        this.unixFormat = false;
    }

    public Object clone() {
        TarEntry entry = null;
        try {
            entry = (TarEntry)super.clone();
            if (this.header != null) {
                entry.header = (TarHeader)this.header.clone();
            }
            if (this.file != null) {
                entry.file = new File(this.file.getAbsolutePath());
            }
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace(System.err);
        }
        return entry;
    }

    public boolean isUSTarFormat() {
        return this.ustarFormat;
    }

    public void setUSTarFormat() {
        this.ustarFormat = true;
        this.gnuFormat = false;
        this.unixFormat = false;
    }

    public boolean isGNUTarFormat() {
        return this.gnuFormat;
    }

    public void setGNUTarFormat() {
        this.gnuFormat = true;
        this.ustarFormat = false;
        this.unixFormat = false;
    }

    public boolean isUnixTarFormat() {
        return this.unixFormat;
    }

    public void setUnixTarFormat() {
        this.unixFormat = true;
        this.ustarFormat = false;
        this.gnuFormat = false;
    }

    public boolean equals(TarEntry it) {
        return this.header.name.toString().equals(it.header.name.toString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TarEntry)) {
            return false;
        }
        return this.equals((TarEntry)obj);
    }

    public int hashCode() {
        return this.header.name.hashCode();
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.header.name.toString().startsWith(this.header.name.toString());
    }

    public TarHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.header.name.toString();
    }

    public void setName(String name) {
        this.header.name = new StringBuffer(name);
    }

    public int getUserId() {
        return this.header.userId;
    }

    public void setUserId(int userId) {
        this.header.userId = userId;
    }

    public int getGroupId() {
        return this.header.groupId;
    }

    public void setGroupId(int groupId) {
        this.header.groupId = groupId;
    }

    public String getUserName() {
        return this.header.userName.toString();
    }

    public void setUserName(String userName) {
        this.header.userName = new StringBuffer(userName);
    }

    public String getGroupName() {
        return this.header.groupName.toString();
    }

    public void setGroupName(String groupName) {
        this.header.groupName = new StringBuffer(groupName);
    }

    public void setIds(int userId, int groupId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
    }

    public void setNames(String userName, String groupName) {
        this.setUserName(userName);
        this.setGroupName(groupName);
    }

    public void setModTime(long time) {
        this.header.modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.header.modTime = time.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.header.modTime * 1000L);
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.header.size;
    }

    public void setSize(long size) {
        this.header.size = size;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            if (this.header.name.toString().endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    public void getFileTarHeader(TarHeader hdr, File file) throws InvalidHeaderException {
        this.file = file;
        String name = file.getPath();
        String osname = System.getProperty("os.name");
        if (osname != null) {
            String Win32Prefix = "windows";
            if (osname.toLowerCase().startsWith(Win32Prefix) && name.length() > 2) {
                char ch1 = name.charAt(0);
                char ch2 = name.charAt(1);
                if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                    name = name.substring(2);
                }
            }
        }
        name = name.replace(File.separatorChar, '/');
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        hdr.linkName = new StringBuffer("");
        hdr.name = new StringBuffer(name);
        if (file.isDirectory()) {
            hdr.size = 0L;
            hdr.mode = 16877;
            hdr.linkFlag = (byte)53;
            if (hdr.name.charAt(hdr.name.length() - 1) != '/') {
                hdr.name.append("/");
            }
        } else {
            hdr.size = file.length();
            hdr.mode = 33188;
            hdr.linkFlag = (byte)48;
        }
        hdr.modTime = file.lastModified() / 1000L;
        hdr.checkSum = 0;
        hdr.devMajor = 0;
        hdr.devMinor = 0;
    }

    public TarEntry[] getDirectoryEntries() throws InvalidHeaderException {
        if (this.file == null || !this.file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] list = this.file.list();
        TarEntry[] result = new TarEntry[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new TarEntry(new File(this.file, list[i]));
        }
        return result;
    }

    public long computeCheckSum(byte[] buf) {
        long sum = 0L;
        for (int i = 0; i < buf.length; ++i) {
            sum += (long)(0xFF & buf[i]);
        }
        return sum;
    }

    public void writeEntryHeader(byte[] outbuf) throws InvalidHeaderException {
        int offset = 0;
        if (this.isUnixTarFormat() && this.header.name.length() > 100) {
            throw new InvalidHeaderException("file path is greater than 100 characters, " + this.header.name);
        }
        offset = TarHeader.getFileNameBytes(this.header.name.toString(), outbuf);
        offset = TarHeader.getOctalBytes(this.header.mode, outbuf, offset, 8);
        offset = TarHeader.getOctalBytes(this.header.userId, outbuf, offset, 8);
        offset = TarHeader.getOctalBytes(this.header.groupId, outbuf, offset, 8);
        long size = this.header.size;
        offset = TarHeader.getLongOctalBytes(size, outbuf, offset, 12);
        int csOffset = offset = TarHeader.getLongOctalBytes(this.header.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.header.linkFlag;
        offset = TarHeader.getNameBytes(this.header.linkName, outbuf, offset, 100);
        if (this.unixFormat) {
            for (int i = 0; i < 8; ++i) {
                outbuf[offset++] = 0;
            }
        } else {
            offset = TarHeader.getNameBytes(this.header.magic, outbuf, offset, 8);
        }
        offset = TarHeader.getNameBytes(this.header.userName, outbuf, offset, 32);
        offset = TarHeader.getNameBytes(this.header.groupName, outbuf, offset, 32);
        offset = TarHeader.getOctalBytes(this.header.devMajor, outbuf, offset, 8);
        offset = TarHeader.getOctalBytes(this.header.devMinor, outbuf, offset, 8);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        long checkSum = this.computeCheckSum(outbuf);
        TarHeader.getCheckSumOctalBytes(checkSum, outbuf, csOffset, 8);
    }

    public void parseTarHeader(TarHeader hdr, byte[] headerBuf) throws InvalidHeaderException {
        int offset = 0;
        if (headerBuf[257] == 0 && headerBuf[258] == 0 && headerBuf[259] == 0 && headerBuf[260] == 0 && headerBuf[261] == 0) {
            this.unixFormat = true;
            this.ustarFormat = false;
            this.gnuFormat = false;
        } else if (headerBuf[257] == 117 && headerBuf[258] == 115 && headerBuf[259] == 116 && headerBuf[260] == 97 && headerBuf[261] == 114 && headerBuf[262] == 0) {
            this.ustarFormat = true;
            this.gnuFormat = false;
            this.unixFormat = false;
        } else if (headerBuf[257] == 117 && headerBuf[258] == 115 && headerBuf[259] == 116 && headerBuf[260] == 97 && headerBuf[261] == 114 && headerBuf[262] != 0 && headerBuf[263] != 0) {
            this.gnuFormat = true;
            this.unixFormat = false;
            this.ustarFormat = false;
        } else {
            StringBuffer buf = new StringBuffer(128);
            buf.append("header magic is not 'ustar' or unix-style zeros, it is '");
            buf.append(headerBuf[257]);
            buf.append(headerBuf[258]);
            buf.append(headerBuf[259]);
            buf.append(headerBuf[260]);
            buf.append(headerBuf[261]);
            buf.append(headerBuf[262]);
            buf.append(headerBuf[263]);
            buf.append("', or (dec) ");
            buf.append(headerBuf[257]);
            buf.append(", ");
            buf.append(headerBuf[258]);
            buf.append(", ");
            buf.append(headerBuf[259]);
            buf.append(", ");
            buf.append(headerBuf[260]);
            buf.append(", ");
            buf.append(headerBuf[261]);
            buf.append(", ");
            buf.append(headerBuf[262]);
            buf.append(", ");
            buf.append(headerBuf[263]);
            throw new InvalidHeaderException(buf.toString());
        }
        hdr.name = TarHeader.parseFileName(headerBuf);
        offset = 100;
        hdr.mode = (int)TarHeader.parseOctal(headerBuf, offset, 8);
        hdr.userId = (int)TarHeader.parseOctal(headerBuf, offset += 8, 8);
        hdr.groupId = (int)TarHeader.parseOctal(headerBuf, offset += 8, 8);
        hdr.size = TarHeader.parseOctal(headerBuf, offset += 8, 12);
        hdr.modTime = TarHeader.parseOctal(headerBuf, offset += 12, 12);
        hdr.checkSum = (int)TarHeader.parseOctal(headerBuf, offset += 12, 8);
        offset += 8;
        hdr.linkFlag = headerBuf[offset++];
        hdr.linkName = TarHeader.parseName(headerBuf, offset, 100);
        offset += 100;
        if (this.ustarFormat) {
            hdr.magic = TarHeader.parseName(headerBuf, offset, 8);
            hdr.userName = TarHeader.parseName(headerBuf, offset += 8, 32);
            hdr.groupName = TarHeader.parseName(headerBuf, offset += 32, 32);
            hdr.devMajor = (int)TarHeader.parseOctal(headerBuf, offset += 32, 8);
            hdr.devMinor = (int)TarHeader.parseOctal(headerBuf, offset += 8, 8);
        } else {
            hdr.devMajor = 0;
            hdr.devMinor = 0;
            hdr.magic = new StringBuffer("");
            hdr.userName = new StringBuffer("");
            hdr.groupName = new StringBuffer("");
        }
    }

    public void nameTarHeader(TarHeader hdr, String name) {
        boolean isDir = name.endsWith("/");
        this.gnuFormat = false;
        this.ustarFormat = true;
        this.unixFormat = false;
        hdr.checkSum = 0;
        hdr.devMajor = 0;
        hdr.devMinor = 0;
        hdr.name = new StringBuffer(name);
        hdr.mode = isDir ? 16877 : 33188;
        hdr.userId = 0;
        hdr.groupId = 0;
        hdr.size = 0L;
        hdr.checkSum = 0;
        hdr.modTime = new Date().getTime() / 1000L;
        hdr.linkFlag = (byte)(isDir ? 53 : 48);
        hdr.linkName = new StringBuffer("");
        hdr.userName = new StringBuffer("");
        hdr.groupName = new StringBuffer("");
        hdr.devMajor = 0;
        hdr.devMinor = 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        return result.append("[TarEntry name=").append(this.getName()).append(", isDir=").append(this.isDirectory()).append(", size=").append(this.getSize()).append(", userId=").append(this.getUserId()).append(", user=").append(this.getUserName()).append(", groupId=").append(this.getGroupId()).append(", group=").append(this.getGroupName()).append("]").toString();
    }
}

