/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CockroachContainer
extends JdbcDatabaseContainer<CockroachContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"cockroachdb/cockroach");
    private static final String DEFAULT_TAG = "v19.1.1";
    public static final String NAME = "cockroach";
    @Deprecated
    public static final String IMAGE = DEFAULT_IMAGE_NAME.getUnversionedPart();
    @Deprecated
    public static final String IMAGE_TAG = "v19.1.1";
    private static final String JDBC_DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final String JDBC_URL_PREFIX = "jdbc:postgresql";
    private static final String TEST_QUERY_STRING = "SELECT 1";
    private static final int REST_API_PORT = 8080;
    private static final int DB_PORT = 26257;
    private String databaseName = "postgres";
    private String username = "root";
    private String password = "";

    @Deprecated
    public CockroachContainer() {
        this(DEFAULT_IMAGE_NAME.withTag("v19.1.1"));
    }

    public CockroachContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public CockroachContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{8080, 26257});
        this.waitingFor(new HttpWaitStrategy().forPath("/health").forPort(8080).forStatusCode(200).withStartupTimeout(Duration.ofMinutes(1L)));
        this.withCommand("start --insecure");
    }

    public String getDriverClassName() {
        return JDBC_DRIVER_CLASS_NAME;
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getMappedPort(26257) + "/" + this.databaseName + additionalUrlParams;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return TEST_QUERY_STRING;
    }

    public CockroachContainer withUsername(String username) {
        throw new UnsupportedOperationException("The CockroachDB docker image does not currently support this - please see https://github.com/cockroachdb/cockroach/issues/19826");
    }

    public CockroachContainer withPassword(String password) {
        throw new UnsupportedOperationException("The CockroachDB docker image does not currently support this - please see https://github.com/cockroachdb/cockroach/issues/19826");
    }

    public CockroachContainer withDatabaseName(String databaseName) {
        throw new UnsupportedOperationException("The CockroachDB docker image does not currently support this - please see https://github.com/cockroachdb/cockroach/issues/19826");
    }
}

