/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.jdbc.filter;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.query.QueryException;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Literal;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.PredicateOperator;
import org.plasma.query.model.Query;
import org.plasma.query.model.Select;
import org.plasma.query.model.Where;
import org.plasma.query.model.WildcardPathElement;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.SQLQueryFilterAssembler;

public class SubqueryFilterAssembler
extends SQLQueryFilterAssembler {
    private static Log log = LogFactory.getLog(SubqueryFilterAssembler.class);
    private String alias;
    private Object[] filterParams;
    private int variableCount = 0;

    public SubqueryFilterAssembler(String alias, Query query, List params, Type contextType) {
        super(contextType, params);
        this.alias = alias;
        this.contextType = contextType;
        this.filterParams = this.filterParams;
        query.accept((QueryVisitor)this);
    }

    public void start(Select select) {
        if (select.getProperties().size() > 1) {
            throw new QueryException("multiple properties on subqueries not supported");
        }
        if (select.getProperties().size() == 0) {
            throw new QueryException("found no properties on subquery");
        }
        AbstractProperty property = (AbstractProperty)select.getProperties().get(0);
        if (!(property instanceof org.plasma.query.model.Property)) {
            throw new QueryException("properties of type '" + property.getClass().getSimpleName() + "' not supported on subquery 'select'");
        }
        if (property.getPath() != null) {
            throw new QueryException("property paths not supported on subquery 'select'");
        }
        Property prop = this.contextType.getProperty(((org.plasma.query.model.Property)property).getName());
        if (!prop.getType().isDataType()) {
            throw new QueryException("reference properties (" + this.contextType.getName() + "." + prop.getName() + ") not supported on subquery 'select'");
        }
        if (prop.isMany()) {
            throw new QueryException("multi-valued properties (" + this.contextType.getName() + "." + prop.getName() + ") not supported on subquery 'select'");
        }
        this.filter.append("select ");
        this.filter.append(String.valueOf(this.alias) + ".");
        this.filter.append(prop.getName() + " ");
        this.filter.append("from org.plasma.sdo.das.pom." + this.contextType.getName() + " " + this.alias);
        this.getContext().setTraversal(Traversal.ABORT);
    }

    public void start(Where where) {
        this.filter.append(" where ");
        super.start((org.plasma.query.Where)where);
    }

    public void start(org.plasma.query.model.Property property) {
        Property endpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)("visit Property, " + property.getName()));
        }
        Path path = property.getPath();
        if (this.filter.length() > 0) {
            this.filter.append(" " + this.alias + ".");
        }
        Type targetType = this.contextType;
        if (path != null) {
            int i = 0;
            while (i < path.getPathNodes().size()) {
                AbstractPathElement pathElem = ((PathNode)path.getPathNodes().get(i)).getPathElement();
                if (pathElem instanceof WildcardPathElement) {
                    throw new DataAccessException("wildcard path elements applicable for 'Select' clause paths only, not 'Where' clause paths");
                }
                Property pdef = targetType.getProperty(((PathElement)pathElem).getValue());
                targetType = pdef.getOpposite().getContainingType();
                if (!pdef.isMany()) {
                    this.filter.append(pdef.getName());
                    this.filter.append(".");
                } else {
                    String variableName = String.valueOf(this.alias) + String.valueOf(this.variableCount);
                    this.filter.append(pdef.getName() + ".contains(" + variableName + ") && " + variableName + ".");
                    ++this.variableCount;
                }
                ++i;
            }
        }
        this.contextProperty = endpoint = targetType.getProperty(property.getName());
        this.filter.append(endpoint.getName());
        super.start(property);
    }

    protected void assembleSubquery(org.plasma.query.model.Property property, PredicateOperator oper, Query query) {
    }

    protected void processWildcardExpression(org.plasma.query.model.Property property, PredicateOperator oper, Literal literal) {
    }
}

