/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.jdbc.service;

import commonj.sdo.Property;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.PropertyPair;
import org.plasma.sdo.access.provider.jdbc.AliasMap;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.jdbc.filter.FilterAssembler;
import org.plasma.sdo.jdbc.service.JDBCServiceException;
import org.plasma.sdo.jdbc.service.RDBDataConverter;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;

public abstract class JDBCSupport {
    private static Log log = LogFactory.getFactory().getInstance(JDBCSupport.class);
    protected RDBDataConverter converter = RDBDataConverter.INSTANCE;

    protected JDBCSupport() {
    }

    /*
     * WARNING - void declaration
     */
    protected StringBuilder createSelectForUpdate(PlasmaType type, List<PropertyPair> keyValues, int waitSeconds) {
        void var11_14;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        ArrayList<Object> props = new ArrayList<Object>();
        for (PropertyPair pair : keyValues) {
            props.add(pair.getProp());
        }
        Property lockingUserProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.user);
        if (lockingUserProperty != null) {
            props.add(lockingUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking user property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property lockingTimestampProperty = type.findProperty(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time);
        if (lockingTimestampProperty != null) {
            props.add(lockingTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find locking timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyUserProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.user);
        if (concurrencyUserProperty != null) {
            props.add(concurrencyUserProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency (username) property for type, " + type.getURI() + "#" + type.getName()));
        }
        Property concurrencyTimestampProperty = type.findProperty(ConcurrencyType.optimistic, ConcurrentDataFlavor.time);
        if (concurrencyTimestampProperty != null) {
            props.add(concurrencyTimestampProperty);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("could not find optimistic concurrency timestamp property for type, " + type.getURI() + "#" + type.getName()));
        }
        int i = 0;
        for (Property property : props) {
            PlasmaProperty prop = (PlasmaProperty)property;
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++i;
        }
        sql.append(" FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        boolean bl = false;
        while (var11_14 < keyValues.size()) {
            if (var11_14 > 0) {
                sql.append(", ");
            }
            PropertyPair propValue = keyValues.get((int)var11_14);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ");
            try {
                this.appendValue(propValue, sql);
            }
            catch (SQLException e) {
                throw new JDBCServiceException(e);
            }
            ++var11_14;
        }
        sql.append(" FOR UPDATE");
        return sql;
    }

    protected String getQualifiedPhysicalName(PlasmaType type) {
        String packageName = type.getPackagePhysicalName();
        if (packageName != null) {
            return String.valueOf(packageName) + "." + type.getPhysicalName();
        }
        return type.getPhysicalName();
    }

    protected StringBuilder createSelect(PlasmaType type, List<String> names, List<PropertyPair> keyValues) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (names.contains(pkProp.getName())) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (String name : names) {
            PlasmaProperty prop = (PlasmaProperty)type.getProperty(name);
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 ");
        sql.append(" WHERE ");
        count = 0;
        while (count < keyValues.size()) {
            if (count > 0) {
                sql.append(" AND ");
            }
            PropertyPair propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ");
            this.appendValue(propValue, sql);
            ++count;
        }
        return sql;
    }

    protected StringBuilder createSelect(PlasmaType type, List<String> names, List<PropertyPair> keyValues, FilterAssembler filterAssembler, List<Object> params, AliasMap aliasMap) throws SQLException {
        PropertyPair propValue;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int count = 0;
        List pkProps = type.findProperties(KeyType.primary);
        for (Property pkProp : pkProps) {
            if (names.contains(pkProp.getName())) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(((PlasmaProperty)pkProp).getPhysicalName());
            ++count;
        }
        for (String name : names) {
            PlasmaProperty prop = (PlasmaProperty)type.getProperty(name);
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (count > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            ++count;
        }
        sql.append(" FROM ");
        Iterator<PlasmaType> it = aliasMap.getTypes();
        count = 0;
        while (it.hasNext()) {
            PlasmaType aliasType = it.next();
            String alias = aliasMap.getAlias(aliasType);
            if (count > 0) {
                sql.append(", ");
            }
            sql.append(this.getQualifiedPhysicalName(aliasType));
            sql.append(" ");
            sql.append(alias);
            ++count;
        }
        sql.append(" ");
        sql.append(filterAssembler.getFilter());
        Object[] objectArray = filterAssembler.getParams();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object filterParam = objectArray[n2];
            params.add(filterParam);
            ++n2;
        }
        count = 0;
        while (count < keyValues.size()) {
            sql.append(" AND ");
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            sql.append(" = ?");
            params.add(this.getParamValue(propValue));
            ++count;
        }
        sql.append(" ORDER BY ");
        count = 0;
        while (count < keyValues.size()) {
            if (count > 0) {
                sql.append(", ");
            }
            propValue = keyValues.get(count);
            sql.append("t0.");
            sql.append(propValue.getProp().getPhysicalName());
            ++count;
        }
        return sql;
    }

    protected StringBuilder createInsert(PlasmaType type, Map<String, PropertyPair> values) {
        PlasmaProperty prop;
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append("(");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(pair.getProp().getPhysicalName());
            pair.setColumn(i + 1);
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType()) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("?");
            ++i;
        }
        sql.append(")");
        return sql;
    }

    protected boolean hasUpdatableProperties(Map<String, PropertyPair> values) {
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary)) continue;
            return true;
        }
        return false;
    }

    protected StringBuilder createUpdate(PlasmaType type, Map<String, PropertyPair> values) {
        PlasmaProperty prop;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" t0 SET ");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || prop.isKey(KeyType.primary)) continue;
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("t0.");
            sql.append(prop.getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(i + 1);
            ++i;
        }
        sql.append(" WHERE ");
        for (PropertyPair pair : values.values()) {
            prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            sql.append("t0.");
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(i + 1);
            ++i;
        }
        return sql;
    }

    protected StringBuilder createDelete(PlasmaType type, Map<String, PropertyPair> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.getQualifiedPhysicalName(type));
        sql.append(" WHERE ");
        int i = 0;
        for (PropertyPair pair : values.values()) {
            PlasmaProperty prop = pair.getProp();
            if (prop.isMany() && !prop.getType().isDataType() || !prop.isKey(KeyType.primary)) continue;
            sql.append(pair.getProp().getPhysicalName());
            sql.append(" = ?");
            pair.setColumn(i + 1);
            ++i;
        }
        return sql;
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Connection con) {
        return this.fetch(type, sql, new Object[0], con);
    }

    protected List<List<PropertyPair>> fetch(PlasmaType type, StringBuilder sql, Object[] params, Connection con) {
        ArrayList<List<PropertyPair>> result = new ArrayList<List<PropertyPair>>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                if (log.isDebugEnabled()) {
                    if (params == null || params.length == 0) {
                        log.debug((Object)("fetch: " + sql.toString()));
                    } else {
                        StringBuilder paramBuf = new StringBuilder();
                        paramBuf.append(" [");
                        int p = 0;
                        while (p < params.length) {
                            if (p > 0) {
                                paramBuf.append(", ");
                            }
                            paramBuf.append(String.valueOf(params[p]));
                            ++p;
                        }
                        paramBuf.append("]");
                        log.debug((Object)("fetch: " + sql.toString() + " " + paramBuf.toString()));
                    }
                }
                statement = con.prepareStatement(sql.toString(), 1003, 1007);
                int i = 0;
                while (i < params.length) {
                    statement.setString(i + 1, String.valueOf(params[i]));
                    ++i;
                }
                statement.execute();
                rs = statement.getResultSet();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int numcols = rsMeta.getColumnCount();
                while (rs.next()) {
                    ArrayList<PropertyPair> row = new ArrayList<PropertyPair>(numcols);
                    result.add(row);
                    int i2 = 1;
                    while (i2 <= numcols) {
                        PlasmaProperty prop;
                        String columnName = rsMeta.getColumnName(i2);
                        int columnType = rsMeta.getColumnType(i2);
                        Object value = this.converter.fromJDBCDataType(rs, i2, columnType, prop = (PlasmaProperty)type.getProperty(columnName));
                        if (value != null) {
                            PropertyPair pair = new PropertyPair(prop, value);
                            row.add(pair);
                        }
                        ++i2;
                    }
                }
            }
            catch (Throwable t) {
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<PlasmaDataObject> fetch(PlasmaDataObject source, PlasmaProperty sourceProperty, StringBuilder sqlQuery, Connection con) {
        ArrayList<PlasmaDataObject> result = new ArrayList<PlasmaDataObject>();
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fetch: " + sqlQuery.toString()));
                }
                statement = con.prepareStatement(sqlQuery.toString(), 1003, 1007);
                statement.execute();
                rs = statement.getResultSet();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int numcols = rsMeta.getColumnCount();
                while (rs.next()) {
                    PlasmaDataObject target = (PlasmaDataObject)source.createDataObject((Property)sourceProperty);
                    result.add(target);
                    int i = 1;
                    while (i <= numcols) {
                        String columnName = rsMeta.getColumnName(i);
                        int columnType = rsMeta.getColumnType(i);
                        PlasmaProperty prop = (PlasmaProperty)target.getType().getProperty(columnName);
                        Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop);
                        if (!prop.isReadOnly()) {
                            target.set((Property)prop, value);
                        } else {
                            CoreDataObject coreObject = (CoreDataObject)target;
                            coreObject.setValue(prop.getName(), value);
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected Map<String, PropertyPair> fetchRowMap(PlasmaType type, StringBuilder sql, Connection con) {
        HashMap<String, PropertyPair> result = new HashMap<String, PropertyPair>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            try {
                statement = con.prepareStatement(sql.toString(), 1003, 1007);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fetch: " + sql.toString()));
                }
                statement.execute();
                rs = statement.getResultSet();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int numcols = rsMeta.getColumnCount();
                while (rs.next()) {
                    int i = 1;
                    while (i <= numcols) {
                        PlasmaProperty prop;
                        String columnName = rsMeta.getColumnName(i);
                        int columnType = rsMeta.getColumnType(i);
                        Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop = (PlasmaProperty)type.getProperty(columnName));
                        if (value != null) {
                            PropertyPair pair = new PropertyPair(prop, value);
                            result.put(prop.getName(), pair);
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected List<PropertyPair> fetchRow(PlasmaType type, StringBuilder sql, Connection con) {
        ArrayList<PropertyPair> result = new ArrayList<PropertyPair>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            try {
                statement = con.prepareStatement(sql.toString(), 1003, 1007);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("fetch: " + sql.toString()));
                }
                statement.execute();
                rs = statement.getResultSet();
                ResultSetMetaData rsMeta = rs.getMetaData();
                int numcols = rsMeta.getColumnCount();
                while (rs.next()) {
                    int i = 1;
                    while (i <= numcols) {
                        PlasmaProperty prop;
                        String columnName = rsMeta.getColumnName(i);
                        int columnType = rsMeta.getColumnType(i);
                        Object value = this.converter.fromJDBCDataType(rs, i, columnType, prop = (PlasmaProperty)type.getProperty(columnName));
                        if (value != null) {
                            PropertyPair pair = new PropertyPair(prop, value);
                            result.add(pair);
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected void execute(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        PreparedStatement statement = null;
        try {
            try {
                statement = con.prepareStatement(sql.toString());
                StringBuilder paramBuf = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("execute: " + sql.toString()));
                    paramBuf = new StringBuilder();
                    paramBuf.append("[");
                }
                int i = 1;
                for (PropertyPair pair : values.values()) {
                    int jdbcType = this.converter.toJDBCDataType(pair.getProp(), pair.getValue());
                    Object jdbcValue = this.converter.toJDBCDataValue(pair.getProp(), pair.getValue());
                    statement.setObject(pair.getColumn(), jdbcValue, jdbcType);
                    if (log.isDebugEnabled()) {
                        if (i > 1) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append("(");
                        paramBuf.append(jdbcValue.getClass().getSimpleName());
                        paramBuf.append("/");
                        paramBuf.append(this.converter.getJdbcTypeName(jdbcType));
                        paramBuf.append(")");
                        paramBuf.append(String.valueOf(jdbcValue));
                    }
                    ++i;
                }
                if (log.isDebugEnabled()) {
                    paramBuf.append("]");
                    log.debug((Object)("params: " + paramBuf.toString()));
                }
                statement.executeUpdate();
            }
            catch (Throwable t) {
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected List<PropertyPair> executeInsert(PlasmaType type, StringBuilder sql, Map<String, PropertyPair> values, Connection con) {
        ArrayList<PropertyPair> resultKeys = new ArrayList<PropertyPair>();
        PreparedStatement statement = null;
        ResultSet generatedKeys = null;
        try {
            try {
                statement = con.prepareStatement(sql.toString(), 1);
                StringBuilder paramBuf = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("execute: " + sql.toString()));
                    paramBuf = new StringBuilder();
                    paramBuf.append("[");
                }
                int i = 1;
                for (PropertyPair pair : values.values()) {
                    int jdbcType = this.converter.toJDBCDataType(pair.getProp(), pair.getValue());
                    Object jdbcValue = this.converter.toJDBCDataValue(pair.getProp(), pair.getValue());
                    statement.setObject(pair.getColumn(), jdbcValue, jdbcType);
                    if (log.isDebugEnabled()) {
                        if (i > 1) {
                            paramBuf.append(", ");
                        }
                        paramBuf.append("(");
                        paramBuf.append(jdbcValue.getClass().getSimpleName());
                        paramBuf.append("/");
                        paramBuf.append(this.converter.getJdbcTypeName(jdbcType));
                        paramBuf.append(")");
                        paramBuf.append(String.valueOf(jdbcValue));
                    }
                    ++i;
                }
                if (log.isDebugEnabled()) {
                    paramBuf.append("]");
                    log.debug((Object)("params: " + paramBuf.toString()));
                }
                statement.execute();
                generatedKeys = statement.getGeneratedKeys();
                ResultSetMetaData rsMeta = generatedKeys.getMetaData();
                int numcols = rsMeta.getColumnCount();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("returned " + numcols + " keys"));
                }
                if (generatedKeys.next()) {
                    List pkPropList = type.findProperties(KeyType.primary);
                    if (pkPropList == null || pkPropList.size() == 0) {
                        throw new DataAccessException("no pri-key properties found for type '" + type.getName() + "'");
                    }
                    if (pkPropList.size() > 1) {
                        throw new DataAccessException("multiple pri-key properties found for type '" + type.getName() + "' - cannot map to generated keys");
                    }
                    PlasmaProperty prop = (PlasmaProperty)pkPropList.get(0);
                    i = 1;
                    while (i <= numcols) {
                        String columnName = rsMeta.getColumnName(i);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("returned key column '" + columnName + "'"));
                        }
                        int columnType = rsMeta.getColumnType(i);
                        Object value = this.converter.fromJDBCDataType(generatedKeys, i, columnType, prop);
                        PropertyPair pair = new PropertyPair(prop, value);
                        resultKeys.add(pair);
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                throw new DataAccessException(t);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return resultKeys;
    }

    private void appendValue(PropertyPair pair, StringBuilder sql) throws SQLException {
        this.appendValue(pair, false, sql);
    }

    private void appendValue(PropertyPair pair, boolean useOldValue, StringBuilder sql) throws SQLException {
        PlasmaProperty valueProp = pair.getProp();
        if (pair.getValueProp() != null) {
            valueProp = pair.getValueProp();
        }
        Object jdbcValue = null;
        jdbcValue = !useOldValue || pair.getOldValue() == null ? RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getValue()) : RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getOldValue());
        DataFlavor dataFlavor = RDBDataConverter.INSTANCE.toJDBCDataFlavor(valueProp);
        switch (dataFlavor) {
            case temporal: 
            case string: 
            case other: {
                sql.append("'");
                sql.append(jdbcValue);
                sql.append("'");
                break;
            }
            default: {
                sql.append(jdbcValue);
            }
        }
    }

    private Object getParamValue(PropertyPair pair) throws SQLException {
        PlasmaProperty valueProp = pair.getProp();
        if (pair.getValueProp() != null) {
            valueProp = pair.getValueProp();
        }
        Object jdbcValue = RDBDataConverter.INSTANCE.toJDBCDataValue(valueProp, pair.getValue());
        DataFlavor dataFlavor = RDBDataConverter.INSTANCE.toJDBCDataFlavor(valueProp);
        switch (dataFlavor) {
            case temporal: 
            case string: 
            case other: {
                break;
            }
        }
        return jdbcValue;
    }
}

