/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.jdbc;

import commonj.sdo.Type;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.helper.DataConverter;

public class JDBCDataConverter {
    private static Log log = LogFactory.getFactory().getInstance(JDBCDataConverter.class);
    public static JDBCDataConverter INSTANCE = JDBCDataConverter.initializeInstance();
    private Map<Integer, String> sqlTypeMap = new HashMap<Integer, String>();

    private JDBCDataConverter() {
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                Integer value = (Integer)fields[i].get(null);
                this.sqlTypeMap.put(value, name);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static synchronized JDBCDataConverter initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JDBCDataConverter();
        }
        return INSTANCE;
    }

    public Object fromJDBCDataType(ResultSet rs, int columnIndex, int sourceType, PlasmaProperty targetProperty) throws SQLException {
        ArrayList<String> result;
        block21: {
            block20: {
                result = null;
                if (!targetProperty.getType().isDataType()) break block20;
                DataType targetDataType = DataType.valueOf((String)targetProperty.getType().getName());
                switch (targetDataType) {
                    case String: 
                    case URI: 
                    case Month: 
                    case MonthDay: 
                    case Day: 
                    case Time: 
                    case Year: 
                    case YearMonth: 
                    case YearMonthDay: 
                    case Duration: {
                        result = rs.getString(columnIndex);
                        break;
                    }
                    case Date: {
                        Timestamp ts = rs.getTimestamp(columnIndex);
                        if (ts != null) {
                            result = new Date(ts.getTime());
                            break;
                        }
                        break block21;
                    }
                    case DateTime: {
                        Timestamp ts = rs.getTimestamp(columnIndex);
                        if (ts != null) {
                            result = new Date(ts.getTime());
                            break;
                        }
                        break block21;
                    }
                    case Decimal: {
                        result = rs.getBigDecimal(columnIndex);
                        break;
                    }
                    case Bytes: {
                        result = (ArrayList<String>)rs.getBytes(columnIndex);
                        break;
                    }
                    case Byte: {
                        result = rs.getByte(columnIndex);
                        break;
                    }
                    case Boolean: {
                        result = rs.getBoolean(columnIndex);
                        break;
                    }
                    case Character: {
                        result = rs.getInt(columnIndex);
                        break;
                    }
                    case Double: {
                        result = rs.getDouble(columnIndex);
                        break;
                    }
                    case Float: {
                        result = Float.valueOf(rs.getFloat(columnIndex));
                        break;
                    }
                    case Int: {
                        result = rs.getInt(columnIndex);
                        break;
                    }
                    case Integer: {
                        result = new BigInteger(rs.getString(columnIndex));
                        break;
                    }
                    case Long: {
                        result = rs.getLong(columnIndex);
                        break;
                    }
                    case Short: {
                        result = rs.getShort(columnIndex);
                        break;
                    }
                    case Strings: {
                        String value = rs.getString(columnIndex);
                        String[] values = value.split("\\s");
                        ArrayList<String> list = new ArrayList<String>(values.length);
                        for (int i = 0; i < values.length; ++i) {
                            list.add(values[i]);
                        }
                        result = list;
                        break;
                    }
                    default: {
                        result = rs.getObject(columnIndex);
                        break;
                    }
                }
                break block21;
            }
            result = rs.getObject(columnIndex);
        }
        return result;
    }

    public int toJDBCDataType(PlasmaProperty sourceProperty, Object value) throws SQLException {
        int result;
        if (sourceProperty.getType().isDataType()) {
            DataType dataType = DataType.valueOf((String)sourceProperty.getType().getName());
            switch (dataType) {
                case String: 
                case URI: 
                case Month: 
                case MonthDay: 
                case Day: 
                case Time: 
                case Year: 
                case YearMonth: 
                case YearMonthDay: 
                case Duration: 
                case Strings: {
                    result = 12;
                    break;
                }
                case Date: {
                    result = 93;
                    break;
                }
                case DateTime: {
                    result = 93;
                    break;
                }
                case Decimal: {
                    result = 3;
                    break;
                }
                case Bytes: {
                    result = -3;
                    break;
                }
                case Byte: {
                    result = -3;
                    break;
                }
                case Boolean: {
                    result = 16;
                    break;
                }
                case Character: {
                    result = 1;
                    break;
                }
                case Double: {
                    result = 8;
                    break;
                }
                case Float: {
                    result = 6;
                    break;
                }
                case Int: {
                    result = 4;
                    break;
                }
                case Integer: {
                    result = -5;
                    break;
                }
                case Long: {
                    result = 4;
                    break;
                }
                case Short: {
                    result = 5;
                    break;
                }
                default: {
                    result = 12;
                    break;
                }
            }
        } else {
            result = 4;
        }
        return result;
    }

    public Object toJDBCDataValue(PlasmaProperty sourceProperty, Object value) throws SQLException {
        Object result;
        if (sourceProperty.getType().isDataType()) {
            DataType dataType = DataType.valueOf((String)sourceProperty.getType().getName());
            switch (dataType) {
                case String: 
                case URI: 
                case Month: 
                case MonthDay: 
                case Day: 
                case Time: 
                case Year: 
                case YearMonth: 
                case YearMonthDay: 
                case Duration: {
                    result = DataConverter.INSTANCE.toString(sourceProperty.getType(), value);
                    break;
                }
                case Date: {
                    Date date = DataConverter.INSTANCE.toDate(sourceProperty.getType(), value);
                    result = new Timestamp(date.getTime());
                    break;
                }
                case DateTime: {
                    Date date = DataConverter.INSTANCE.toDate(sourceProperty.getType(), value);
                    result = new Timestamp(date.getTime());
                    break;
                }
                case Decimal: {
                    result = DataConverter.INSTANCE.toDecimal(sourceProperty.getType(), value);
                    break;
                }
                case Bytes: {
                    result = DataConverter.INSTANCE.toBytes(sourceProperty.getType(), value);
                    break;
                }
                case Byte: {
                    result = DataConverter.INSTANCE.toByte(sourceProperty.getType(), value);
                    break;
                }
                case Boolean: {
                    result = DataConverter.INSTANCE.toBoolean(sourceProperty.getType(), value);
                    break;
                }
                case Character: {
                    result = DataConverter.INSTANCE.toString(sourceProperty.getType(), value);
                    break;
                }
                case Double: {
                    result = DataConverter.INSTANCE.toDouble(sourceProperty.getType(), value);
                    break;
                }
                case Float: {
                    result = DataConverter.INSTANCE.toDouble(sourceProperty.getType(), value);
                    break;
                }
                case Int: {
                    result = DataConverter.INSTANCE.toInt(sourceProperty.getType(), value);
                    break;
                }
                case Integer: {
                    result = DataConverter.INSTANCE.toInteger(sourceProperty.getType(), value);
                    break;
                }
                case Long: {
                    result = DataConverter.INSTANCE.toLong(sourceProperty.getType(), value);
                    break;
                }
                case Short: {
                    result = DataConverter.INSTANCE.toShort(sourceProperty.getType(), value);
                    break;
                }
                case Strings: {
                    result = DataConverter.INSTANCE.toString(sourceProperty.getType(), value);
                    break;
                }
                default: {
                    result = DataConverter.INSTANCE.toString(sourceProperty.getType(), value);
                    break;
                }
            }
        } else {
            result = (Long)value;
        }
        return result;
    }

    public String toJDBCString(Type sourceType, PlasmaProperty sourceProperty, Object value) {
        String result = null;
        DataFlavor flavor = sourceProperty.getDataFlavor();
        switch (flavor) {
            case integral: 
            case real: {
                result = value.toString();
                break;
            }
            case string: {
                result = "'" + value.toString() + "'";
                break;
            }
            default: {
                result = value.toString();
            }
        }
        return result;
    }

    public String getJdbcTypeName(int jdbcType) {
        return this.sqlTypeMap.get(jdbcType);
    }
}

