/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.jdbc.service;

import commonj.sdo.DataObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.jdbc.service.CommitComparator;

public class CreatedCommitComparator
extends CommitComparator {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getFactory().getInstance(CreatedCommitComparator.class);

    @Override
    public int compare(CoreDataObject source, CoreDataObject target) {
        PlasmaType targetType = (PlasmaType)target.getType();
        PlasmaType sourceType = (PlasmaType)source.getType();
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)source.getDataGraph().getChangeSummary();
        int targetDepth = changeSummary.getPathDepth((DataObject)target);
        int sourceDepth = changeSummary.getPathDepth((DataObject)source);
        if (targetType.getQualifiedName() != sourceType.getQualifiedName()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing types: " + sourceType.toString() + " / " + targetType.toString()));
            }
            if (this.isSingularRelation((DataObject)source, (DataObject)target)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("(return 1) - singular relation from source: " + sourceType.toString() + " to target: " + targetType.toString()));
                }
                return 1;
            }
            if (this.isSingularRelation((DataObject)target, (DataObject)source)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("(return -1) - singular relation from target: " + targetType.toString() + " to source: " + sourceType.toString()));
                }
                return -1;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"(return 0)");
            }
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing data objects : " + source.toString() + " / " + target.toString()));
        }
        if (this.hasChildLink((DataObject)source, (DataObject)target)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("singular link from : " + source.toString() + " to: " + target.toString()));
            }
            return 1;
        }
        if (sourceDepth < targetDepth) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("depth: " + sourceDepth + " / " + targetDepth));
            }
            return -1;
        }
        return 1;
    }
}

