/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.jdbc.filter;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.query.model.OrderBy;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Property;
import org.plasma.query.model.QueryConstants;
import org.plasma.query.model.SortDirection;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.EntityConstants;
import org.plasma.sdo.access.provider.jdbc.AliasMap;
import org.plasma.sdo.jdbc.filter.Functions;

public class OrderingDeclarationAssembler
extends DefaultQueryVisitor
implements QueryConstants,
EntityConstants {
    private static Log log = LogFactory.getLog(OrderingDeclarationAssembler.class);
    private PlasmaType contextType;
    private commonj.sdo.Property contextProp;
    private StringBuilder orderingDeclaration = new StringBuilder();
    private AliasMap aliasMap;

    private OrderingDeclarationAssembler() {
    }

    public OrderingDeclarationAssembler(OrderBy orderby, PlasmaType contextType, AliasMap aliasMap) {
        this.contextType = contextType;
        this.aliasMap = aliasMap;
        if (orderby.getTextContent() == null) {
            orderby.accept((QueryVisitor)this);
        } else {
            this.orderingDeclaration.append(orderby.getTextContent().getValue());
        }
    }

    public String getOrderingDeclaration() {
        return this.orderingDeclaration.toString();
    }

    public void start(Property property) {
        List functions;
        if (this.orderingDeclaration.length() == 0) {
            this.orderingDeclaration.append("ORDER BY ");
        }
        if (this.orderingDeclaration.length() > "ORDER BY ".length()) {
            this.orderingDeclaration.append(", ");
        }
        PlasmaType targetType = this.contextType;
        if (property.getPath() != null) {
            Path path = property.getPath();
            int i = 0;
            while (i < path.getPathNodes().size()) {
                PlasmaProperty prop = (PlasmaProperty)targetType.getProperty(((PathNode)path.getPathNodes().get(i)).getPathElement().getValue());
                targetType = (PlasmaType)prop.getType();
                ++i;
            }
        }
        PlasmaProperty endpoint = (PlasmaProperty)targetType.getProperty(property.getName());
        this.contextProp = endpoint;
        String targetAlias = this.aliasMap.getAlias(targetType);
        if (targetAlias == null) {
            targetAlias = this.aliasMap.addAlias(targetType);
        }
        if ((functions = property.getFunctions()) == null || functions.size() == 0) {
            this.orderingDeclaration.append(String.valueOf(targetAlias) + "." + endpoint.getPhysicalName());
        } else {
            this.orderingDeclaration.append(Functions.wrap(endpoint, functions, targetAlias));
        }
        if (property.getDirection() == null || property.getDirection().ordinal() == SortDirection.ASC.ordinal()) {
            this.orderingDeclaration.append(" ASC");
        } else {
            this.orderingDeclaration.append(" DESC");
        }
        this.getContext().setTraversal(Traversal.ABORT);
    }
}

