/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.jdbc.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.query.model.GroupBy;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Property;
import org.plasma.query.model.QueryConstants;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.provider.common.EntityConstants;
import org.plasma.sdo.access.provider.jdbc.AliasMap;

public class GroupingDeclarationAssembler
extends DefaultQueryVisitor
implements QueryConstants,
EntityConstants {
    private static Log log = LogFactory.getLog(GroupingDeclarationAssembler.class);
    private PlasmaType contextType;
    private commonj.sdo.Property contextProp;
    private StringBuilder groupingDeclaration = new StringBuilder();
    private AliasMap aliasMap;

    private GroupingDeclarationAssembler() {
    }

    public GroupingDeclarationAssembler(GroupBy groupby, PlasmaType contextType, AliasMap aliasMap) {
        this.contextType = contextType;
        this.aliasMap = aliasMap;
        if (groupby.getTextContent() == null) {
            groupby.accept((QueryVisitor)this);
        } else {
            this.groupingDeclaration.append(groupby.getTextContent().getValue());
        }
    }

    public String getGroupingDeclaration() {
        return this.groupingDeclaration.toString();
    }

    public void start(Property property) {
        if (this.groupingDeclaration.length() == 0) {
            this.groupingDeclaration.append("GROUP BY ");
        }
        if (this.groupingDeclaration.length() > "GROUP BY ".length()) {
            this.groupingDeclaration.append(", ");
        }
        PlasmaType targetType = this.contextType;
        if (property.getPath() != null) {
            Path path = property.getPath();
            int i = 0;
            while (i < path.getPathNodes().size()) {
                PlasmaProperty prop = (PlasmaProperty)targetType.getProperty(((PathNode)path.getPathNodes().get(i)).getPathElement().getValue());
                targetType = (PlasmaType)prop.getType();
                ++i;
            }
        }
        PlasmaProperty endpoint = (PlasmaProperty)targetType.getProperty(property.getName());
        this.contextProp = endpoint;
        String alias = this.aliasMap.getAlias(targetType);
        if (alias == null) {
            alias = this.aliasMap.addAlias(targetType);
        }
        this.groupingDeclaration.append(alias);
        this.groupingDeclaration.append(".");
        this.groupingDeclaration.append(endpoint.getPhysicalName());
        this.getContext().setTraversal(Traversal.ABORT);
    }
}

