/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.jdbc.service;

import commonj.sdo.DataGraph;
import commonj.sdo.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.query.model.From;
import org.plasma.query.model.Query;
import org.plasma.query.model.QueryValidator;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.PlasmaDataAccessService;
import org.plasma.sdo.core.SnapshotMap;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.jdbc.connect.RDBConnectionManager;
import org.plasma.sdo.jdbc.service.GraphDispatcher;
import org.plasma.sdo.jdbc.service.GraphQuery;
import org.xml.sax.SAXException;

public class JDBCGraphService
implements PlasmaDataAccessService {
    private static Log log = LogFactory.getLog(JDBCGraphService.class);

    public void initialize() {
    }

    public void close() {
    }

    public int count(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("expected non-null 'query' argument");
        }
        this.validate(query);
        if (log.isDebugEnabled()) {
            this.log(query);
        }
        GraphQuery dispatcher = new GraphQuery();
        return dispatcher.count(query);
    }

    public int[] count(Query[] queries) {
        if (queries == null) {
            throw new IllegalArgumentException("expected non-null 'queries' argument");
        }
        int[] counts = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            counts[i] = this.count(queries[i]);
        }
        return counts;
    }

    public DataGraph[] find(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("expected non-null 'query' argument");
        }
        if (log.isDebugEnabled()) {
            this.log(query);
        }
        GraphQuery dispatcher = new GraphQuery();
        Timestamp snapshotDate = new Timestamp(new Date().getTime());
        return dispatcher.find(query, snapshotDate);
    }

    public DataGraph[] find(Query query, int maxResults) {
        if (query == null) {
            throw new IllegalArgumentException("expected non-null 'query' argument");
        }
        this.validate(query);
        if (log.isDebugEnabled()) {
            this.log(query);
        }
        GraphQuery dispatcher = new GraphQuery();
        PlasmaDataGraph[] results = dispatcher.find(query, -1, new Timestamp(new Date().getTime()));
        return results;
    }

    public List<DataGraph[]> find(Query[] queries) {
        if (queries == null) {
            throw new IllegalArgumentException("expected non-null 'queries' argument");
        }
        GraphQuery dispatcher = new GraphQuery();
        ArrayList<DataGraph[]> list = new ArrayList<DataGraph[]>();
        Timestamp snapshotDate = new Timestamp(new Date().getTime());
        for (int i = 0; i < queries.length; ++i) {
            this.validate(queries[i]);
            if (log.isDebugEnabled()) {
                this.log(queries[i]);
            }
            PlasmaDataGraph[] results = dispatcher.find(queries[i], snapshotDate);
            list.add((DataGraph[])results);
        }
        return list;
    }

    public SnapshotMap commit(DataGraph dataGraph, String username) {
        if (dataGraph == null) {
            throw new IllegalArgumentException("expected non-null 'dataGraph' argument");
        }
        if (username == null) {
            throw new IllegalArgumentException("expected non-null 'username' argument");
        }
        if (username.trim().length() == 0) {
            throw new IllegalArgumentException("unexpected zero length 'username' argument");
        }
        SnapshotMap snapshotMap = new SnapshotMap(new Timestamp(new Date().getTime()));
        Connection con = null;
        try {
            con = RDBConnectionManager.instance().getConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException e2) {
            throw new DataAccessException((Throwable)e2);
        }
        GraphDispatcher dispatcher = new GraphDispatcher(snapshotMap, username, con);
        try {
            dispatcher.commit(dataGraph);
            con.commit();
            SnapshotMap snapshotMap2 = snapshotMap;
            return snapshotMap2;
        }
        catch (DataAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                log.error((Object)e.getMessage(), (Throwable)e1);
            }
            throw e;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)t.getMessage(), t);
            }
            try {
                con.rollback();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException(t);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
            dispatcher.close();
        }
    }

    public SnapshotMap commit(DataGraph[] dataGraphs, String username) {
        if (dataGraphs == null) {
            throw new IllegalArgumentException("expected non-null 'dataGraphs' argument");
        }
        if (username == null) {
            throw new IllegalArgumentException("expected non-null 'username' argument");
        }
        if (username.trim().length() == 0) {
            throw new IllegalArgumentException("unexpected zero length 'username' argument");
        }
        SnapshotMap snapshotMap = new SnapshotMap(new Timestamp(new Date().getTime()));
        Connection con = null;
        try {
            con = RDBConnectionManager.instance().getConnection();
            con.setAutoCommit(false);
        }
        catch (SQLException e2) {
            throw new DataAccessException((Throwable)e2);
        }
        GraphDispatcher dispatcher = new GraphDispatcher(snapshotMap, username, con);
        try {
            for (int i = 0; i < dataGraphs.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("commiting: " + dataGraphs[i].getChangeSummary().toString()));
                }
                dispatcher.commit(dataGraphs[i]);
            }
            con.commit();
            SnapshotMap i = snapshotMap;
            return i;
        }
        catch (DataAccessException e) {
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                con.rollback();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new DataAccessException(t);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
            dispatcher.close();
        }
    }

    private void validate(Query query) {
        From from = query.getFromClause();
        Type type = PlasmaTypeHelper.INSTANCE.getType(from.getEntity().getNamespaceURI(), from.getEntity().getName());
        log.debug((Object)"validating query");
        new QueryValidator(query, type);
    }

    private void log(Query query) {
        String xml = "";
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            xml = binding.marshal((Object)query);
        }
        catch (JAXBException jAXBException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        log.debug((Object)("query: " + xml));
    }
}

