/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.Map;
import org.terracotta.entity.EntityUserException;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.voltron.proxy.ClientId;
import org.terracotta.voltron.proxy.Codec;
import org.terracotta.voltron.proxy.CommonProxyFactory;
import org.terracotta.voltron.proxy.MessageType;
import org.terracotta.voltron.proxy.MethodDescriptor;
import org.terracotta.voltron.proxy.ProxyEntityMessage;
import org.terracotta.voltron.proxy.ProxyEntityResponse;
import org.terracotta.voltron.proxy.SerializationCodec;

public class ProxyMessageCodec
implements MessageCodec<ProxyEntityMessage, ProxyEntityResponse> {
    private final EnumMap<MessageType, Map<Byte, MethodDescriptor>> methodMappings = new EnumMap(MessageType.class);
    private final EnumMap<MessageType, Map<MethodDescriptor, Byte>> reverseMethodMappings = new EnumMap(MessageType.class);
    private final EnumMap<MessageType, Map<Class<?>, Byte>> responseMappings = new EnumMap(MessageType.class);
    private final EnumMap<MessageType, Map<Byte, Class<?>>> reverseResponseMappings = new EnumMap(MessageType.class);
    private Codec codec = new SerializationCodec();

    public ProxyMessageCodec(Class<?> proxyType) {
        this(proxyType, new Class[0], null, null);
    }

    public ProxyMessageCodec(Class<?> proxyType, Class<?>[] eventTypes) {
        this(proxyType, eventTypes, null, null);
    }

    public ProxyMessageCodec(Class<?> proxyType, Class<?>[] eventTypes, Class<?> messengerType, Class<?> synchronizerType) {
        this.methodMappings.put(MessageType.MESSAGE, CommonProxyFactory.createMethodMappings(proxyType));
        this.reverseMethodMappings.put(MessageType.MESSAGE, CommonProxyFactory.invert(this.methodMappings.get((Object)MessageType.MESSAGE)));
        this.responseMappings.put(MessageType.MESSAGE, CommonProxyFactory.createResponseTypeMappings(proxyType, eventTypes));
        this.reverseResponseMappings.put(MessageType.MESSAGE, CommonProxyFactory.invert(this.responseMappings.get((Object)MessageType.MESSAGE)));
        if (synchronizerType != null) {
            this.methodMappings.put(MessageType.SYNC, CommonProxyFactory.createMethodMappings(synchronizerType));
            this.reverseMethodMappings.put(MessageType.SYNC, CommonProxyFactory.invert(this.methodMappings.get((Object)MessageType.SYNC)));
            this.responseMappings.put(MessageType.SYNC, CommonProxyFactory.createResponseTypeMappings(synchronizerType));
            this.reverseResponseMappings.put(MessageType.SYNC, CommonProxyFactory.invert(this.responseMappings.get((Object)MessageType.SYNC)));
        }
        if (messengerType != null) {
            this.methodMappings.put(MessageType.MESSENGER, CommonProxyFactory.createMethodMappings(messengerType));
            this.reverseMethodMappings.put(MessageType.MESSENGER, CommonProxyFactory.invert(this.methodMappings.get((Object)MessageType.MESSENGER)));
            this.responseMappings.put(MessageType.MESSENGER, CommonProxyFactory.createResponseTypeMappings(messengerType));
            this.reverseResponseMappings.put(MessageType.MESSENGER, CommonProxyFactory.invert(this.responseMappings.get((Object)MessageType.MESSENGER)));
        }
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public byte[] encodeResponse(ProxyEntityResponse r) throws MessageCodecException {
        if (r == null) {
            return new byte[0];
        }
        MessageType messageType = r.getMessageType();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteOut);
        try {
            output.writeByte(messageType.ordinal());
            output.writeByte(messageType == MessageType.ERROR ? 0 : (int)this.getMessageTypeIdentifier(r).byteValue());
            output.write(this.codec.encode(r.getResponseType(), r.getResponse()));
            output.close();
        }
        catch (Exception e) {
            throw new MessageCodecException("Error encoding ProxyEntityResponse", (Throwable)e);
        }
        return byteOut.toByteArray();
    }

    public ProxyEntityResponse decodeResponse(byte[] buffer) throws MessageCodecException {
        if (buffer.length == 0) {
            return null;
        }
        try {
            MessageType messageType = MessageType.values()[buffer[0]];
            Class<EntityUserException> responseType = messageType == MessageType.ERROR ? EntityUserException.class : this.getResponseType(messageType, buffer[1]);
            EntityUserException o = this.codec.decode(responseType, buffer, 2, buffer.length - 2);
            return ProxyEntityResponse.response(messageType, responseType, o);
        }
        catch (Exception e) {
            throw new MessageCodecException("Error decoding ProxyEntityResponse", (Throwable)e);
        }
    }

    public byte[] encodeMessage(ProxyEntityMessage message) throws MessageCodecException {
        try {
            MessageType messageType = message.getType();
            MethodDescriptor method = message.getMethod();
            Byte methodIdentifier = this.getMethodIdentifier(message);
            Object[] args = message.getArguments();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int parameterAnnotationsLength = parameterAnnotations.length;
            for (int i = 0; i < parameterAnnotationsLength; ++i) {
                Annotation[] parameterAnnotation;
                for (Annotation annotation : parameterAnnotation = parameterAnnotations[i]) {
                    if (annotation.annotationType() != ClientId.class) continue;
                    args[i] = null;
                }
            }
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteOut);
            output.writeByte(messageType.ordinal());
            output.writeByte(methodIdentifier.byteValue());
            output.write(this.codec.encode(method.getParameterTypes(), args));
            output.close();
            return byteOut.toByteArray();
        }
        catch (Exception ex) {
            throw new MessageCodecException("Error encoding ProxyEntityMessage", (Throwable)ex);
        }
    }

    public ProxyEntityMessage decodeMessage(byte[] buffer) throws MessageCodecException {
        try {
            MessageType messageType = MessageType.values()[buffer[0]];
            MethodDescriptor method = this.getMethod(messageType, buffer[1]);
            return new ProxyEntityMessage(method, this.codec.decode(method.getParameterTypes(), buffer, 2, buffer.length - 2), messageType);
        }
        catch (Exception ex) {
            throw new MessageCodecException("Error decoding ProxyEntityMessage", (Throwable)ex);
        }
    }

    private MethodDescriptor getMethod(MessageType messageType, Byte b) {
        Map<Byte, MethodDescriptor> mapping = this.methodMappings.get((Object)messageType);
        if (mapping == null) {
            throw new AssertionError((Object)("No mapping for " + (Object)((Object)messageType)));
        }
        MethodDescriptor method = mapping.get(b);
        if (method == null) {
            throw new AssertionError((Object)("No mapping for method " + b + " for messageType " + (Object)((Object)messageType)));
        }
        return method;
    }

    private Class<?> getResponseType(MessageType messageType, Byte b) {
        Map<Byte, Class<?>> mapping = this.reverseResponseMappings.get((Object)messageType);
        if (mapping == null) {
            throw new AssertionError((Object)("No mapping for " + (Object)((Object)messageType)));
        }
        Class<?> responseType = mapping.get(b);
        if (responseType == null) {
            throw new AssertionError((Object)("No mapping for method " + b + " for messageType " + (Object)((Object)messageType)));
        }
        return responseType;
    }

    private Byte getMethodIdentifier(ProxyEntityMessage message) {
        Map<MethodDescriptor, Byte> mapping = this.reverseMethodMappings.get((Object)message.getType());
        if (mapping == null) {
            throw new AssertionError((Object)("No mapping for " + (Object)((Object)message.getType())));
        }
        Byte methodIdentifier = mapping.get(message.getMethod());
        if (methodIdentifier == null) {
            throw new AssertionError((Object)("No mapping for " + message.getMethod().toGenericString()));
        }
        return methodIdentifier;
    }

    private Byte getMessageTypeIdentifier(ProxyEntityResponse response) {
        Map<Class<?>, Byte> mapping = this.responseMappings.get((Object)response.getMessageType());
        if (mapping == null) {
            throw new AssertionError((Object)("No mapping for " + (Object)((Object)response.getMessageType())));
        }
        Byte messageTypeIdentifier = mapping.get(response.getResponseType());
        if (messageTypeIdentifier == null) {
            throw new AssertionError((Object)("No mapping for " + response.getResponseType().getName()));
        }
        return messageTypeIdentifier;
    }
}

