/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.voltron.proxy;

import com.tc.classloader.CommonComponent;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.EntityUserException;
import org.terracotta.voltron.proxy.MessageType;

@CommonComponent
public final class ProxyEntityResponse
implements EntityResponse {
    private final MessageType messageType;
    private final Class<?> responseType;
    private final Object response;

    public static ProxyEntityResponse response(MessageType messageType, Class<?> responseType, Object response) {
        return new ProxyEntityResponse(messageType, responseType, response);
    }

    public static ProxyEntityResponse messageResponse(Class<?> responseType, Object response) {
        return ProxyEntityResponse.response(MessageType.MESSAGE, responseType, response);
    }

    public static ProxyEntityResponse syncResponse(Class<?> responseType, Object response) {
        return ProxyEntityResponse.response(MessageType.SYNC, responseType, response);
    }

    public static ProxyEntityResponse messengerResponse(Class<?> responseType, Object response) {
        return ProxyEntityResponse.response(MessageType.MESSENGER, responseType, response);
    }

    public static ProxyEntityResponse error(EntityUserException error) {
        return ProxyEntityResponse.response(MessageType.ERROR, EntityUserException.class, error);
    }

    private ProxyEntityResponse(MessageType messageType, Class<?> responseType, Object response) {
        this.messageType = messageType;
        this.responseType = responseType;
        this.response = response;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Class<?> getResponseType() {
        return this.responseType;
    }

    public Object getResponse() {
        return this.response;
    }
}

